/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dnd;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class DimensionHandleDropAdapter
implements IDropAdapter {
    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        EditPart editPart;
        if (!this.isDimensionHandle(transfer)) {
            return 0;
        }
        if (target instanceof EditPart && (editPart = (EditPart)target).getModel() instanceof IVirtualValidator) {
            if (((IVirtualValidator)editPart.getModel()).handleValidate(transfer)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private boolean isDimensionHandle(Object transfer) {
        if (transfer instanceof Object[]) {
            Object[] items = (Object[])transfer;
            DesignElementHandle container = null;
            int i = 0;
            while (i < items.length) {
                if (!(items[i] instanceof DimensionHandle)) {
                    return false;
                }
                if (container == null) {
                    container = ((DimensionHandle)items[i]).getContainer();
                } else if (container != ((DimensionHandle)items[i]).getContainer()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return transfer instanceof DimensionHandle;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (target instanceof EditPart) {
            EditPart editPart = (EditPart)target;
            CreateRequest request = new CreateRequest();
            request.getExtendedData().put("newObject", transfer);
            request.setLocation(location.getPoint());
            Command command = editPart.getCommand((Request)request);
            if (command != null && command.canExecute()) {
                editPart.getViewer().getEditDomain().getCommandStack().execute(command);
                CrosstabReportItemHandle crosstab = this.getCrosstab(editPart);
                if (crosstab != null) {
                    AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(crosstab);
                    providerWrapper.updateAllAggregationCells(0);
                }
                return true;
            }
            return false;
        }
        if (target instanceof PropertyHandle) {
            DimensionHandle dimensionHandle = (DimensionHandle)transfer;
            CrosstabReportItemHandle xtabHandle = null;
            int axisType = 0;
            PropertyHandle property = (PropertyHandle)target;
            DesignElementHandle handle = property.getElementHandle();
            xtabHandle = (CrosstabReportItemHandle)CrosstabUtil.getReportItem((DesignElementHandle)handle);
            boolean ret = this.createDimensionViewHandle(xtabHandle, dimensionHandle, axisType = property.getPropertyDefn().getName().equals("columns") ? 1 : 0);
            if (ret) {
                AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(xtabHandle);
                providerWrapper.updateAllAggregationCells(0);
            }
            return ret;
        }
        return false;
    }

    private boolean createDimensionViewHandle(CrosstabReportItemHandle xtabHandle, DimensionHandle dimensionHandle, int type) {
        HierarchyHandle hierarchyHandle;
        DimensionViewHandle viewHandle;
        CommandStack stack;
        block4: {
            stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans("Create Dimension");
            try {
                viewHandle = xtabHandle.insertDimension(dimensionHandle, type, 0);
                hierarchyHandle = dimensionHandle.getDefaultHierarchy();
                int count = hierarchyHandle.getLevelCount();
                if (count != 0) break block4;
                stack.rollback();
                return false;
            }
            catch (SemanticException e) {
                stack.rollback();
                ExceptionUtil.handle((Throwable)e);
                return false;
            }
        }
        LevelHandle levelHandle = hierarchyHandle.getLevel(0);
        DataItemHandle dataHandle = CrosstabAdaptUtil.createColumnBindingAndDataItem((ReportItemHandle)((ExtendedItemHandle)xtabHandle.getModelHandle()), levelHandle);
        LevelViewHandle levelViewHandle = viewHandle.insertLevel(levelHandle, 0);
        CrosstabCellHandle cellHandle = levelViewHandle.getCell();
        cellHandle.addContent((DesignElementHandle)dataHandle);
        ActionHandle actionHandle = levelHandle.getActionHandle();
        if (actionHandle != null) {
            ArrayList<IStructure> source = new ArrayList<IStructure>();
            source.add(actionHandle.getStructure());
            ArrayList newAction = ModelUtil.cloneStructList(source);
            dataHandle.setAction((Action)newAction.get(0));
        }
        stack.commit();
        return true;
    }

    private CrosstabReportItemHandle getCrosstab(EditPart editPart) {
        CrosstabReportItemHandle crosstab = null;
        Object tmp = editPart.getModel();
        if (!(tmp instanceof CrosstabCellAdapter)) {
            return null;
        }
        if (tmp instanceof VirtualCrosstabCellAdapter) {
            return ((VirtualCrosstabCellAdapter)tmp).getCrosstabReportItemHandle();
        }
        CrosstabCellHandle handle = ((CrosstabCellAdapter)tmp).getCrosstabCellHandle();
        if (handle != null) {
            crosstab = handle.getCrosstab();
        }
        return crosstab;
    }
}

