/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;

public class ChoicePropertyDescriptorProvider
extends PropertyDescriptorProvider {
    String[] values = null;

    public ChoicePropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    public String[] getItems() {
        if ("dataSet".equals(this.getProperty())) {
            return ChoiceSetFactory.getDataSets();
        }
        if ("masterPage".equals(this.getProperty())) {
            return ChoiceSetFactory.getMasterPages();
        }
        if ("style".equals(this.getProperty())) {
            String[] itemsArray = ChoiceSetFactory.getStyles();
            itemsArray = this.filterPreStyles(itemsArray);
            return itemsArray;
        }
        if ("theme".equals(this.getProperty())) {
            return ChoiceSetFactory.getThemes();
        }
        IChoiceSet cset = this.getChoiceSet();
        this.values = ChoiceSetFactory.getNamefromChoiceSet((IChoiceSet)cset);
        return ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)cset);
    }

    private String[] filterPreStyles(String[] items) {
        String[] newItems = items;
        if (items == null) {
            newItems = new String[]{};
        }
        List preStyles = new DesignEngine(new DesignConfig()).getMetaData().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < newItems.length) {
            if (preStyleNames.indexOf(newItems[i2]) == -1) {
                sytleNames.add(newItems[i2]);
            }
            ++i2;
        }
        return sytleNames.toArray(new String[0]);
    }

    public String[] getValues() {
        return this.values;
    }

    private IChoiceSet getChoiceSet() {
        GroupElementHandle multiSelectionHandle = DEUtil.getMultiSelectionHandle((List)DEUtil.getInputElements((Object)this.input));
        return multiSelectionHandle.getPropertyHandle(this.getProperty()).getPropertyDefn().getChoices();
    }

    public boolean assertProperty() {
        return "style".equals(this.getProperty()) || "theme".equals(this.getProperty());
    }
}

