/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.internal.dom.odf.OdfPlugin;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODFWriter {
    private static final String SLASH = "/";

    private void addFileToZip(ZipOutputStream zipOutputStream, String string, File file) throws IOException, Exception {
        if (file.isDirectory()) {
            String string2 = file.getPath();
            string2 = string2.substring(string.length() + 1);
            string2 = string2.replaceAll("\\\\", SLASH);
            ZipEntry zipEntry = new ZipEntry(String.valueOf(string2) + SLASH);
            zipEntry.setSize(0L);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.closeEntry();
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.addFileToZip(zipOutputStream, string, fileArray[n]);
                ++n;
            }
        } else {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            String string3 = file.getPath();
            string3 = string3.substring(string.length() + 1);
            string3 = string3.replaceAll("\\\\", SLASH);
            ZipEntry zipEntry = new ZipEntry(string3);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            zipOutputStream.closeEntry();
        }
    }

    public List<String> unzipODFFile(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileOutputStream fileOutputStream = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            ZipFile zipFile = null;
            zipFile = uRL != null ? new ZipFile(new File(uRL.toURI())) : new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object;
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName();
                if (string3.contains(SLASH)) {
                    int n = string3.lastIndexOf(SLASH);
                    object = new File(String.valueOf(string2) + File.separator + string3.substring(0, n));
                    if (!((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                }
                if (string3.endsWith(SLASH)) continue;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                object = String.valueOf(string2) + File.separator + string3;
                arrayList.add((String)object);
                fileOutputStream = new FileOutputStream((String)object);
                try {
                    try {
                        int n;
                        byte[] byArray = new byte[8192];
                        while ((n = bufferedInputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        zipFile.close();
                        fileOutputStream.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    zipFile.close();
                    fileOutputStream.close();
                    throw throwable;
                }
                zipFile.close();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void createODFFile(String string, String string2) {
        File file = new File(string);
        if (file.isDirectory()) {
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {}
            try {
                File file2 = null;
                file2 = uRL != null ? new File(uRL.toURI()) : new File(string2);
                File[] fileArray = file.listFiles();
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
                int n = 0;
                while (n < fileArray.length) {
                    this.addFileToZip(zipOutputStream, string, fileArray[n]);
                    ++n;
                }
                zipOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean rmDir(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (!this.rmDir(fileArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return file.delete();
    }

    public void saveODFFile(ODFDocument oDFDocument, String string) {
        String string2 = oDFDocument.getURL();
        IPath iPath = OdfPlugin.getDefault().getStateLocation().append("tmp");
        File file = iPath.toFile();
        file.mkdir();
        String string3 = file.getPath();
        ODFWriter oDFWriter = new ODFWriter();
        oDFWriter.unzipODFFile(string2, string3);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string3) + System.getProperty("file.separator") + "content.xml");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMSource dOMSource = new DOMSource(oDFDocument);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            try {
                transformerFactory.newTransformer().transform(dOMSource, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
            }
            catch (TransformerException transformerException) {
                transformerException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        oDFWriter.createODFFile(string3, string);
        this.rmDir(file);
    }
}

