/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.w3c.dom.Element;

public class TmfXmlTimestampCondition
implements ITmfXmlCondition {
    private final IXmlTimestampsCondition fTimestampsCondition;
    private final IXmlStateSystemContainer fParent;

    public TmfXmlTimestampCondition(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        String type;
        this.fParent = container;
        switch (type = node.getNodeName()) {
            case "timerange": {
                this.fTimestampsCondition = new TmfXmlTimeRangeCondition(modelFactory, node, this.fParent);
                break;
            }
            case "elapsedTime": {
                this.fTimestampsCondition = new TmfXmlElapsedTimeCondition(modelFactory, node, this.fParent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid timestampsChecker declaration in XML : Type should be timeRange or elapsedTime");
            }
        }
    }

    public static long valueToNanoseconds(long timestamp, String unit) {
        switch (unit) {
            case "ns": {
                return timestamp;
            }
            case "us": {
                return TmfTimestamp.create((long)timestamp, (int)-6).toNanos();
            }
            case "ms": {
                return TmfTimestamp.create((long)timestamp, (int)-3).toNanos();
            }
            case "s": {
                return TmfTimestamp.create((long)timestamp, (int)0).toNanos();
            }
        }
        throw new IllegalArgumentException("The time unit is not yet supporting.");
    }

    private static boolean compareSign(long i, long j) {
        return i < 0L ^ j >= 0L;
    }

    @Override
    public boolean test(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        return this.fTimestampsCondition.test(event, scenarioInfo);
    }

    private static enum ElapsedTimeOperator {
        LESS,
        EQUAL,
        MORE,
        NONE;

    }

    private static interface IXmlTimestampsCondition
    extends ITmfXmlCondition {
    }

    private static enum TimeRangeOperator {
        IN,
        OUT,
        OTHER;

    }

    private class TmfXmlElapsedTimeCondition
    implements IXmlTimestampsCondition {
        private final IXmlStateSystemContainer fContainer;
        private final ElapsedTimeOperator fType;
        private final String fUnit;
        private final String fValue;
        private final String fReferenceState;

        public TmfXmlElapsedTimeCondition(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
            String type;
            String unit;
            this.fContainer = container;
            this.fUnit = unit = node.getAttribute("unit");
            List<@Nullable Element> childElements = XmlUtils.getChildElements(node);
            if (childElements.size() != 1) {
                throw new IllegalArgumentException("Invalid timestampsChecker declaration in XML : Only one timing condition is allowed");
            }
            Element firstElement = (Element)NonNullUtils.checkNotNull((Object)childElements.get(0));
            switch (type = firstElement.getNodeName()) {
                case "less": {
                    this.fType = ElapsedTimeOperator.LESS;
                    break;
                }
                case "equal": {
                    this.fType = ElapsedTimeOperator.EQUAL;
                    break;
                }
                case "more": {
                    this.fType = ElapsedTimeOperator.MORE;
                    break;
                }
                default: {
                    this.fType = ElapsedTimeOperator.NONE;
                }
            }
            String reference = firstElement.getAttribute("since");
            String value = firstElement.getAttribute("value");
            this.fReferenceState = reference;
            this.fValue = value;
        }

        @Override
        public boolean test(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            boolean success;
            long referenceTimestamps;
            if (scenarioInfo == null) {
                Activator.logError("Elapse time conditions require scenarioInfos and scenarioInfos is null");
                return false;
            }
            long ts = event.getTimestamp().toNanos();
            if (!TmfXmlTimestampCondition.compareSign(ts, referenceTimestamps = ((XmlPatternStateProvider)this.fContainer).getHistoryBuilder().getSpecificStateStartTime(this.fContainer, this.fReferenceState, scenarioInfo, event)) || ts < referenceTimestamps) {
                throw new IllegalArgumentException("Timestamp is inferior to reference time");
            }
            switch (this.fType) {
                case LESS: {
                    success = ts - referenceTimestamps < TmfXmlTimestampCondition.valueToNanoseconds(Long.parseLong(this.fValue), this.fUnit);
                    break;
                }
                case EQUAL: {
                    success = ts - referenceTimestamps == TmfXmlTimestampCondition.valueToNanoseconds(Long.parseLong(this.fValue), this.fUnit);
                    break;
                }
                case MORE: {
                    success = ts - referenceTimestamps > TmfXmlTimestampCondition.valueToNanoseconds(Long.parseLong(this.fValue), this.fUnit);
                    break;
                }
                default: {
                    success = false;
                }
            }
            return success;
        }
    }

    private class TmfXmlTimeRangeCondition
    implements IXmlTimestampsCondition {
        private final TimeRangeOperator fType;
        private final String fUnit;
        private final String fBegin;
        private final String fEnd;
        private final IXmlStateSystemContainer fContainer;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public TmfXmlTimeRangeCondition(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
            String type;
            String unit;
            this.fContainer = container;
            this.fUnit = unit = node.getAttribute("unit");
            @Nullable List childElements = (List)NonNullUtils.checkNotNull(XmlUtils.getChildElements(node));
            if (childElements.size() != 1) {
                throw new IllegalArgumentException("Invalid timestampsChecker declaration in XML : Only one timing condition is allowed");
            }
            Element firstElement = (Element)NonNullUtils.checkNotNull((Object)((Element)childElements.get(0)));
            switch (type = firstElement.getNodeName()) {
                case "in": {
                    this.fType = TimeRangeOperator.IN;
                    break;
                }
                case "out": {
                    this.fType = TimeRangeOperator.OUT;
                    break;
                }
                default: {
                    this.fType = TimeRangeOperator.OTHER;
                }
            }
            String begin = firstElement.getAttribute("begin");
            String end = firstElement.getAttribute("end");
            this.fBegin = begin;
            this.fEnd = end;
        }

        @Override
        public boolean test(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            long end;
            ITmfStateSystem ss = this.fContainer.getStateSystem();
            long begin = TmfXmlTimestampCondition.valueToNanoseconds(Long.parseLong(this.fBegin), this.fUnit);
            if (begin > (end = TmfXmlTimestampCondition.valueToNanoseconds(Long.parseLong(this.fEnd), this.fUnit))) {
                begin ^= end;
                end = begin ^ end;
                begin ^= end;
            }
            begin = Math.max(ss.getStartTime(), begin);
            end = Math.min(ss.getCurrentEndTime(), end);
            begin = Math.min(begin, end);
            long ts = event.getTimestamp().toNanos();
            switch (this.fType) {
                case IN: {
                    return this.intersects(begin, end, ts);
                }
                case OUT: {
                    return !this.intersects(begin, end, ts);
                }
            }
            return false;
        }

        private boolean intersects(long begin, long end, long ts) {
            return ts >= begin && ts <= end;
        }
    }
}

