/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.CTFClock;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.ctf.core.trace.Metadata;
import org.eclipse.tracecompass.ctf.core.trace.MetadataComparator;
import org.eclipse.tracecompass.ctf.core.trace.MetadataFileFilter;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.SafeMappedByteBuffer;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.internal.ctf.core.trace.Utils;

public class CTFTrace
implements IDefinitionScope {
    private final File fPath;
    private Long fMajor;
    private Long fMinor;
    private UUID fUuid;
    private ByteOrder fByteOrder;
    private StructDeclaration fPacketHeaderDecl = null;
    private CTFClock fSingleClock = null;
    private StructDefinition fPacketHeaderDef;
    private final Map<Long, ICTFStream> fStreams = new HashMap<Long, ICTFStream>();
    private Map<String, String> fEnvironment = new HashMap<String, String>();
    private final Map<String, CTFClock> fClocks = new HashMap<String, CTFClock>();
    private static final FileFilter METADATA_FILE_FILTER = new MetadataFileFilter();
    private static final Comparator<File> METADATA_COMPARATOR = new MetadataComparator();
    private final DeclarationScope fScope = new DeclarationScope(null, "trace");
    private boolean fUUIDMismatchWarning = false;

    public String toString() {
        return "CTFTrace [path=" + this.fPath + ", major=" + this.fMajor + ", minor=" + this.fMinor + ", uuid=" + this.fUuid + "]";
    }

    public CTFTrace(String path) throws CTFException {
        this(new File(path));
    }

    public CTFTrace(File path) throws CTFException {
        this.fPath = path;
        Metadata metadata = new Metadata(this);
        if (!this.fPath.exists()) {
            throw new CTFException("Trace (" + path.getPath() + ") doesn't exist. Deleted or moved?");
        }
        if (!this.fPath.isDirectory()) {
            throw new CTFException("Path must be a valid directory");
        }
        metadata.parseFile();
        this.init(path);
    }

    public CTFTrace() {
        this.fPath = null;
    }

    private void init(File path) throws CTFException {
        File[] files = path.listFiles(METADATA_FILE_FILTER);
        Arrays.sort(files, METADATA_COMPARATOR);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File streamFile = fileArray[n2];
            this.openStreamInput(streamFile);
            ++n2;
        }
        for (ICTFStream stream : this.getStreams()) {
            Set<CTFStreamInput> inputs = stream.getStreamInputs();
            for (CTFStreamInput s : inputs) {
                this.addStream(s);
            }
        }
    }

    public Collection<IEventDeclaration> getEventDeclarations(Long streamId) {
        ICTFStream stream = this.fStreams.get(streamId);
        if (stream == null) {
            return null;
        }
        return stream.getEventDeclarations();
    }

    public ICTFStream getStream(Long id) {
        if (id == null) {
            return this.fStreams.get(0L);
        }
        return this.fStreams.get(id);
    }

    public int nbStreams() {
        return this.fStreams.size();
    }

    public void setMajor(long major) {
        this.fMajor = major;
    }

    public void setMinor(long minor) {
        this.fMinor = minor;
    }

    public void setUUID(UUID uuid) {
        this.fUuid = uuid;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.fByteOrder = byteOrder;
    }

    public void setPacketHeader(StructDeclaration packetHeader) {
        this.fPacketHeaderDecl = packetHeader;
    }

    public boolean majorIsSet() {
        return this.fMajor != null;
    }

    public boolean minorIsSet() {
        return this.fMinor != null;
    }

    public boolean uuidIsSet() {
        return this.fUuid != null;
    }

    public boolean byteOrderIsSet() {
        return this.fByteOrder != null;
    }

    public boolean packetHeaderIsSet() {
        return this.fPacketHeaderDecl != null;
    }

    public UUID getUUID() {
        return this.fUuid;
    }

    public long getMajor() {
        return this.fMajor;
    }

    public long getMinor() {
        return this.fMinor;
    }

    public final ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public StructDeclaration getPacketHeader() {
        return this.fPacketHeaderDecl;
    }

    public File getTraceDirectory() {
        return this.fPath;
    }

    public Iterable<ICTFStream> getStreams() {
        return this.fStreams.values();
    }

    public String getPath() {
        return this.fPath != null ? this.fPath.getPath() : "";
    }

    private void addStream(CTFStreamInput s) {
        ICTFStream stream = s.getStream();
        this.fStreams.put(stream.getId(), stream);
        s.setupIndex();
    }

    private ICTFStream openStreamInput(File streamFile) throws CTFException {
        ICTFStream stream;
        if (!streamFile.canRead()) {
            throw new CTFException("Unreadable file : " + streamFile.getPath());
        }
        if (streamFile.length() == 0L) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var6_5 = null;
            try (FileChannel fc = FileChannel.open(streamFile.toPath(), StandardOpenOption.READ);){
                ByteBuffer byteBuffer = SafeMappedByteBuffer.map(fc, FileChannel.MapMode.READ_ONLY, 0L, (int)Math.min(fc.size(), 4096L));
                if (byteBuffer == null) {
                    throw new IllegalStateException("Failed to allocate memory");
                }
                BitBuffer streamBitBuffer = new BitBuffer(byteBuffer, this.getByteOrder());
                if (this.fPacketHeaderDecl != null) {
                    this.fPacketHeaderDef = this.fPacketHeaderDecl.createDefinition((IDefinitionScope)this, ILexicalScope.PACKET_HEADER, streamBitBuffer);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CTFException(e);
        }
        StructDefinition packetHeaderDef = this.getPacketHeaderDef();
        if (packetHeaderDef != null) {
            CTFTrace.validateMagicNumber(packetHeaderDef);
            this.validateUUID(packetHeaderDef);
            Definition streamIDDef = packetHeaderDef.lookupDefinition("stream_id");
            if (streamIDDef instanceof IntegerDefinition) {
                long streamID = ((IntegerDefinition)streamIDDef).getValue();
                stream = this.fStreams.get(streamID);
            } else {
                stream = this.getStream(null);
            }
        } else {
            stream = this.getStream(null);
        }
        if (stream == null) {
            throw new CTFException("Unexpected end of stream");
        }
        if (!(stream instanceof CTFStream)) {
            throw new CTFException("Stream is not a CTFStream, but rather a " + stream.getClass().getCanonicalName());
        }
        CTFStream ctfStream = (CTFStream)stream;
        ctfStream.addInput(new CTFStreamInput(ctfStream, streamFile));
        return ctfStream;
    }

    private void validateUUID(StructDefinition packetHeaderDef) throws CTFException {
        UUID otheruuid;
        Definition lookupDefinition = packetHeaderDef.lookupDefinition("uuid");
        AbstractArrayDefinition uuidDef = (AbstractArrayDefinition)lookupDefinition;
        if (uuidDef != null && !this.fUuid.equals(otheruuid = Utils.getUUIDfromDefinition(uuidDef)) && !this.fUUIDMismatchWarning) {
            this.fUUIDMismatchWarning = true;
            Activator.log(2, "Reading CTF trace: UUID mismatch for trace " + this);
        }
    }

    private static void validateMagicNumber(StructDefinition packetHeaderDef) throws CTFException {
        int magic;
        IntegerDefinition magicDef = (IntegerDefinition)packetHeaderDef.lookupDefinition("magic");
        if (magicDef != null && (magic = (int)magicDef.getValue()) != -1040441407) {
            throw new CTFException("CTF magic mismatch");
        }
    }

    public static ByteOrder startsWithMagicNumber(File file, int magicNumber) throws CTFException {
        int magicSize = 4;
        if (file.length() < (long)magicSize) {
            return null;
        }
        byte[] magic = new byte[magicSize];
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream is = new FileInputStream(file);){
                ((InputStream)is).read(magic, 0, magic.length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CTFIOException(e);
        }
        ByteBuffer bb = ByteBuffer.wrap(magic);
        if (CTFTrace.isMagicWithEndianness(bb, ByteOrder.LITTLE_ENDIAN, magicNumber)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        if (CTFTrace.isMagicWithEndianness(bb, ByteOrder.BIG_ENDIAN, magicNumber)) {
            return ByteOrder.BIG_ENDIAN;
        }
        return null;
    }

    private static boolean isMagicWithEndianness(ByteBuffer byteBuffer, ByteOrder endianness, int magicNumber) {
        byteBuffer.position(0);
        byteBuffer.order(endianness);
        int magic = byteBuffer.getInt();
        return magic == magicNumber;
    }

    @Override
    public ILexicalScope getScopePath() {
        return ILexicalScope.TRACE;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals(ILexicalScope.TRACE_PACKET_HEADER.getPath())) {
            return this.getPacketHeaderDef();
        }
        return null;
    }

    public void addStreamFile(File streamFile) throws CTFException {
        this.openStreamInput(streamFile);
    }

    public void addStream(ICTFStream stream) throws ParseException {
        if (this.fStreams.get(null) != null) {
            throw new ParseException("Stream without id with multiple streams");
        }
        if (!stream.isIdSet() && !this.fStreams.isEmpty()) {
            throw new ParseException("Stream without id with multiple streams");
        }
        ICTFStream existingStream = this.fStreams.get(stream.getId());
        if (existingStream != null) {
            throw new ParseException("Stream id already exists");
        }
        this.fStreams.put(stream.getId(), stream);
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.fEnvironment);
    }

    public void addClock(String nameValue, CTFClock ctfClock) {
        this.fClocks.put(nameValue, ctfClock);
    }

    public CTFClock getClock(String name) {
        return this.fClocks.get(name);
    }

    public final CTFClock getClock() {
        if (this.fSingleClock != null && this.fClocks.size() == 1) {
            return this.fSingleClock;
        }
        if (this.fClocks.size() == 1) {
            this.fSingleClock = this.fClocks.get(this.fClocks.keySet().iterator().next());
            return this.fSingleClock;
        }
        return null;
    }

    public final long getOffset() {
        if (this.getClock() == null) {
            return 0L;
        }
        return this.fSingleClock.getClockOffset();
    }

    private double getTimeScale() {
        if (this.getClock() == null) {
            return 1.0;
        }
        return this.fSingleClock.getClockScale();
    }

    public long getCurrentStartTime() {
        long currentStart = Long.MAX_VALUE;
        for (ICTFStream stream : this.fStreams.values()) {
            for (CTFStreamInput si : stream.getStreamInputs()) {
                currentStart = Math.min(currentStart, si.getIndex().getElement(0).getTimestampBegin());
            }
        }
        return this.timestampCyclesToNanos(currentStart);
    }

    public long getCurrentEndTime() {
        long currentEnd = Long.MIN_VALUE;
        for (ICTFStream stream : this.fStreams.values()) {
            for (CTFStreamInput si : stream.getStreamInputs()) {
                currentEnd = Math.max(currentEnd, si.getTimestampEnd());
            }
        }
        return this.timestampCyclesToNanos(currentEnd);
    }

    private boolean clockNeedsScale() {
        if (this.getClock() == null) {
            return false;
        }
        return this.fSingleClock.isClockScaled();
    }

    private double getInverseTimeScale() {
        if (this.getClock() == null) {
            return 1.0;
        }
        return this.fSingleClock.getClockAntiScale();
    }

    public long timestampCyclesToNanos(long cycles) {
        long retVal = cycles + this.getOffset();
        if (this.clockNeedsScale()) {
            retVal = (long)((double)retVal * this.getTimeScale());
        }
        return retVal;
    }

    public long timestampNanoToCycles(long nanos) {
        long retVal = this.clockNeedsScale() ? (long)((double)nanos * this.getInverseTimeScale()) : nanos;
        return retVal - this.getOffset();
    }

    public void addStream(long id, File streamFile) throws CTFException {
        File file = streamFile;
        if (file == null) {
            throw new CTFException("cannot create a stream with no file");
        }
        ICTFStream stream = this.fStreams.get(id);
        if (stream == null) {
            stream = new CTFStream(this);
            this.fStreams.put(id, stream);
        }
        if (!(stream instanceof CTFStream)) {
            throw new CTFException("Stream does not support adding input");
        }
        CTFStream ctfStream = (CTFStream)stream;
        ctfStream.addInput(new CTFStreamInput(stream, file));
    }

    public DeclarationScope getScope() {
        return this.fScope;
    }

    public StructDefinition getPacketHeaderDef() {
        return this.fPacketHeaderDef;
    }

    public void setEnvironment(@NonNull Map<String, String> parseEnvironment) {
        this.fEnvironment = ImmutableMap.copyOf(parseEnvironment);
    }
}

