/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage.KernelMemoryUsageDataProvider;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedThreadQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.swtchart.Chart;

public class KernelMemoryUsageViewer
extends TmfCommonXLineChartViewer {
    private static final @NonNull String NOT_SELECTED = "-1";
    private @NonNull String fSelectedThread = "-1";

    public KernelMemoryUsageViewer(Composite parent) {
        super(parent, Messages.MemoryUsageViewer_title, Messages.MemoryUsageViewer_xAxis, Messages.MemoryUsageViewer_yAxis);
        Chart chart = this.getSwtChart();
        chart.getAxisSet().getYAxis(0).getTick().setFormat(DataSizeWithUnitFormat.getInstance());
        chart.getLegend().setPosition(1024);
        chart.getLegend().setVisible(false);
    }

    protected void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        this.setDataProvider((ITmfXYDataProvider)KernelMemoryUsageDataProvider.create((ITmfTrace)trace));
    }

    protected TimeQueryFilter createQueryFilter(long start, long end, int nb) {
        return new SelectedThreadQueryFilter(start, end, nb, this.fSelectedThread);
    }

    public void setSelectedThread(@NonNull String tid) {
        this.cancelUpdate();
        this.deleteSeries(this.fSelectedThread);
        this.fSelectedThread = tid;
        this.updateContent();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.initSelection();
        super.traceSelected(signal);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.initSelection();
        super.traceOpened(signal);
    }

    private void initSelection() {
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        Object data = ctx.getData("org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview.KERNEL_MEMORY");
        String thread = data instanceof String ? (String)data : NOT_SELECTED;
        this.setSelectedThread(thread);
    }
}

