/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.cpuusage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedThreadQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CpuUsageDataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfXYDataProvider {
    private static final String NOT_SELECTED = "-1";
    private static final String TOTAL_SERIES_NAME = Objects.requireNonNull(Messages.CpuUsageDataProvider_total);
    private static final Set<Integer> ALL_CPUS = Collections.emptySet();
    private final KernelCpuUsageAnalysis fModule;

    public static @Nullable CpuUsageDataProvider create(ITmfTrace trace) {
        KernelCpuUsageAnalysis module = (KernelCpuUsageAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        if (module != null) {
            module.schedule();
            return new CpuUsageDataProvider(trace, module);
        }
        return null;
    }

    private CpuUsageDataProvider(ITmfTrace trace, KernelCpuUsageAnalysis module) {
        super(trace);
        this.fModule = module;
    }

    public TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        TmfModelResponse res = this.verifyParameters(this.fModule, filter, monitor);
        if (res != null) {
            return res;
        }
        ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem(), "Statesystem should have been verified by verifyParameters");
        String selectedThread = NOT_SELECTED;
        Set cpus = ALL_CPUS;
        if (filter instanceof SelectedThreadQueryFilter) {
            selectedThread = ((SelectedThreadQueryFilter)filter).getSelectedThread();
            if (filter instanceof SelectedCpuQueryFilter) {
                cpus = ((SelectedCpuQueryFilter)filter).getCpu();
            }
        }
        long[] xValues = filter.getTimesRequested();
        double[] totalValues = new double[xValues.length];
        double[] selectedThreadValues = new double[xValues.length];
        long prevTime = Math.max(filter.getStart(), ss.getStartTime());
        long currentEnd = ss.getCurrentEndTime();
        int i = 1;
        while (i < xValues.length) {
            long time = xValues[i];
            if (time >= ss.getStartTime() && time <= currentEnd && prevTime < time) {
                Map cpuUsageMap = Maps.filterKeys(this.fModule.getCpuUsageInRange(cpus, prevTime, time), key -> key.startsWith("total"));
                long totalCpu = 0L;
                for (Map.Entry entry : cpuUsageMap.entrySet()) {
                    String threadName = CpuUsageDataProvider.extractThreadName((String)entry.getKey());
                    if (threadName == null) continue;
                    long cpuTime = (Long)entry.getValue();
                    totalCpu += cpuTime;
                    if (!selectedThread.equals(threadName)) continue;
                    selectedThreadValues[i] = CpuUsageDataProvider.normalize(prevTime, time, cpuTime);
                }
                totalValues[i] = CpuUsageDataProvider.normalize(prevTime, time, totalCpu);
                prevTime = time;
            }
            if (monitor != null && monitor.isCanceled()) {
                return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
            }
            ++i;
        }
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        ySeries.put((Object)TOTAL_SERIES_NAME, (Object)new YModel(TOTAL_SERIES_NAME, totalValues));
        if (selectedThread != NOT_SELECTED) {
            ySeries.put((Object)selectedThread, (Object)new YModel(selectedThread, selectedThreadValues));
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.CpuUsageDataProvider_title), (long[])xValues, (Map)ySeries.build(), (boolean)complete);
    }

    private static double normalize(long prevTime, long time, long value) {
        return (double)value / (double)(time - prevTime) * 100.0;
    }

    private static @Nullable String extractThreadName(String key) {
        String[] strings = key.split("/", 2);
        if (strings.length > 1 && !strings[1].equals("0")) {
            return strings[1];
        }
        return null;
    }
}

