/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

public class SVNRepositoryNotification {
    public final String path;
    public final NodeAction nodeAction;
    public final Action action;
    public final long revision;
    public final String warning;
    public final long shard;
    public final long newRevision;
    public final long oldRevision;

    public SVNRepositoryNotification(String path, NodeAction nodeAction, Action action, long revision, String warning, long shard, long newRevision, long oldRevision) {
        this.path = path;
        this.nodeAction = nodeAction;
        this.action = action;
        this.revision = revision;
        this.warning = warning;
        this.shard = shard;
        this.newRevision = newRevision;
        this.oldRevision = oldRevision;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        UNKNOWN(-1),
        WARNING(0),
        DUMP_REV_END(1),
        VERIFY_REV_END(2),
        PACK_SHARD_START(3),
        PACK_SHARD_END(4),
        PACK_SHARD_START_REVPROP(5),
        PACK_SHARD_END_REVPROP(6),
        LOAD_TXN_START(7),
        LOAD_TXN_COMMITTED(8),
        LOAD_NODE_START(9),
        LOAD_NODE_END(10),
        LOAD_COPIED_NODE(11),
        LOAD_NORMALIZED_MERGEINFO(12),
        MUTEX_ACQUIRED(13),
        RECOVER_START(14),
        UPGRADE_START(15),
        LOAD_SKIPPED_REV(16),
        VERIFY_REV_STRUCTURE(17);

        public final int id;

        public static boolean isActionKnown(int action) {
            return action >= Action.WARNING.id && action <= Action.VERIFY_REV_STRUCTURE.id;
        }

        public static Action fromId(int id) {
            Action[] actionArray = Action.values();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action kind = actionArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid action kind: " + id);
        }

        private Action(int id) {
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeAction {
        UNKNOWN(-1),
        CHANGE(0),
        ADD(1),
        DELETE(2),
        REPLACE(3);

        public final int id;

        public static boolean isActionKnown(int action) {
            return action >= NodeAction.CHANGE.id && action <= NodeAction.REPLACE.id;
        }

        public static NodeAction fromId(int id) {
            NodeAction[] nodeActionArray = NodeAction.values();
            int n = nodeActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeAction kind = nodeActionArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid node action kind: " + id);
        }

        private NodeAction(int id) {
            this.id = id;
        }
    }
}

