/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.tcf.debug.ui.ITCFLaunchContext;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.launch.TCFLaunchContext;

public class TCFPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expected_value) {
        if (property.equals("areUpdatePoliciesSupported")) {
            return this.testUpdatePoliciesSupported(receiver);
        }
        if (property.equals("isExecutable")) {
            return this.testIsExecutable(receiver, expected_value);
        }
        return false;
    }

    private boolean testUpdatePoliciesSupported(Object receiver) {
        return receiver instanceof IDebugView;
    }

    private boolean testIsExecutable(Object receiver, Object expected_value) {
        Boolean value = null;
        try {
            IAdaptable selection;
            ITCFLaunchContext context;
            if (receiver instanceof IAdaptable && (context = TCFLaunchContext.getLaunchContext(selection = (IAdaptable)receiver)) != null) {
                IProject project = context.getProject(selection);
                IPath path = context.getPath(selection);
                if (project != null && path != null) {
                    value = context.isBinary(project, path);
                }
            }
        }
        catch (Throwable x) {
            Activator.log(x);
        }
        if (expected_value != null) {
            return expected_value.equals(value);
        }
        return value instanceof Boolean && (Boolean)value != false;
    }
}

