/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.commands.StepCommand;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;

public class ResumeCommand
extends StepCommand
implements IResumeHandler {
    public ResumeCommand(TCFModel model) {
        super(model);
    }

    @Override
    protected boolean canExecute(IRunControl.RunControlContext ctx) {
        return ctx.canResume(0);
    }

    @Override
    protected void execute(final IDebugCommandRequest monitor, final IRunControl.RunControlContext ctx, boolean src_step, final Runnable done) {
        new TCFAction(this.model.getLaunch(), ctx.getID()){
            boolean cmd_sent;

            public void run() {
                if (this.cmd_sent) {
                    TCFDataCache<TCFContextState> state;
                    TCFNode node = ResumeCommand.this.model.getNode(this.ctx_id);
                    if (node instanceof TCFNodeExecContext && !(state = ((TCFNodeExecContext)node).getState()).validate((Runnable)((Object)this))) {
                        return;
                    }
                    this.done();
                    return;
                }
                this.cmd_sent = true;
                ctx.resume(0, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null && (this).ResumeCommand.this.model.getChannel().getState() == 1) {
                            IErrorReport r;
                            if (error instanceof IErrorReport && (r = (IErrorReport)error).getErrorCode() == 12) {
                                this.run();
                                return;
                            }
                            launch.removeContextActions(this.getContextID());
                            monitor.setStatus((IStatus)new Status(4, "org.eclipse.tcf.debug.ui", 0, "Cannot resume: " + error.getLocalizedMessage(), (Throwable)error));
                        }
                        this.run();
                    }
                });
            }

            public void done() {
                super.done();
                done.run();
            }
        };
    }
}

