/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.action;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.dialect.command.RenameRepresentationCommand;
import org.eclipse.sirius.common.ui.tools.api.dialog.RenameDialog;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;

public class RenameRepresentationAction
extends Action {
    private Collection<DRepresentationDescriptor> selectedRepDescriptions;

    public RenameRepresentationAction(Collection<DRepresentationDescriptor> selectedRepDescriptions) {
        super(Messages.RenameRepresentationAction_name);
        this.selectedRepDescriptions = selectedRepDescriptions;
    }

    public void run() {
        for (DRepresentationDescriptor repDesc : this.selectedRepDescriptions) {
            this.renameRepresentation(repDesc);
        }
    }

    private void renameRepresentation(DRepresentationDescriptor repDescriptor) {
        String newName;
        String oldName = repDescriptor.getName() != null ? repDescriptor.getName() : "";
        RenameDialog dialog = new RenameDialog(Display.getCurrent().getActiveShell(), true, oldName);
        dialog.create();
        if (dialog.open() == 0 && !oldName.equals(newName = dialog.getNewName())) {
            TransactionalEditingDomain transDomain = TransactionUtil.getEditingDomain((EObject)repDescriptor);
            transDomain.getCommandStack().execute((Command)new RenameRepresentationCommand(transDomain, repDescriptor, newName));
        }
    }

    public boolean isEnabled() {
        boolean isEnabled = super.isEnabled();
        if (isEnabled) {
            for (DRepresentationDescriptor dRepDescription : this.selectedRepDescriptions) {
                DRepresentation dRepresentation = dRepDescription.getRepresentation();
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)dRepresentation);
                if (permissionAuthority.canEditFeature((EObject)dRepresentation, ViewpointPackage.eINSTANCE.getDRepresentation_Name().getName())) continue;
                isEnabled = false;
                break;
            }
        }
        return isEnabled;
    }
}

