/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ITransparentFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.StyledFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.TransparentFigureGraphicsModifier;

public class LozengeFigure
extends Shape
implements StyledFigure,
ITransparentFigure {
    private int viewpointAlpha = 100;
    private boolean transparent;

    protected void outlineShape(Graphics graphics) {
        PointList pointList = this.getPointList();
        graphics.drawPolygon(pointList);
    }

    protected void fillShape(Graphics graphics) {
        TransparentFigureGraphicsModifier modifier = new TransparentFigureGraphicsModifier(this, graphics);
        modifier.pushState();
        graphics.fillPolygon(this.getPointList());
        modifier.popState();
    }

    protected PointList getPointList() {
        Rectangle r = new Rectangle();
        PointList pointList = new PointList();
        r.x = this.bounds.x + this.getLineWidth() / 2;
        r.y = this.bounds.y + this.getLineWidth() / 2;
        r.width = this.bounds.width - this.getLineWidth();
        r.height = this.bounds.height - this.getLineWidth();
        pointList.removeAllPoints();
        pointList.addPoint(r.x + r.width / 2, r.y);
        pointList.addPoint(r.x + r.width, r.y + r.height / 2);
        pointList.addPoint(r.x + r.width / 2, r.y + r.height);
        pointList.addPoint(r.x, r.y + r.height / 2);
        return pointList;
    }

    @Override
    public int getSiriusAlpha() {
        return this.viewpointAlpha;
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public void setSiriusAlpha(int alpha) {
        this.viewpointAlpha = alpha;
    }

    @Override
    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }
}

