/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;

public class CreateConnectionCommand
extends Command {
    private SapphireDiagramEditorPagePart diagramPart;
    private IDiagramConnectionDef connDef;
    private final DiagramNodeModel source;
    private DiagramNodeModel target;

    public CreateConnectionCommand(DiagramNodeModel source, IDiagramConnectionDef connDef) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("connection creation");
        this.source = source;
        this.connDef = connDef;
        this.diagramPart = (SapphireDiagramEditorPagePart)source.getModelPart().nearest(SapphireDiagramEditorPagePart.class);
    }

    public boolean canExecute() {
        if (this.target == null) {
            return false;
        }
        ConnectionService connService = (ConnectionService)this.diagramPart.service(ConnectionService.class);
        return connService.valid(this.source.getModelPart(), this.target.getModelPart(), (String)this.connDef.getId().content());
    }

    public void execute() {
        ConnectionService connService = (ConnectionService)this.diagramPart.service(ConnectionService.class);
        DiagramConnectionPart connection = connService.connect(this.source.getModelPart(), this.target.getModelPart(), (String)this.connDef.getId().content());
        if (connection != null && connection.canEditLabel()) {
            this.diagramPart.selectAndDirectEdit((ISapphirePart)connection);
        }
    }

    public void setTarget(DiagramNodeModel target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }
}

