/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.commands.AbstractCommand;
import org.eclipse.remote.proxy.protocol.core.SerializableFileInfo;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class PutInfoCommand
extends AbstractCommand<Void> {
    private final DataOutputStream out;
    private final DataInputStream in;
    private final IFileInfo info;
    private final int options;
    private final String path;

    public PutInfoCommand(ProxyConnection conn, IFileInfo info, int options, String path) {
        super(conn);
        this.out = new DataOutputStream(conn.getCommandChannel().getOutputStream());
        this.in = new DataInputStream(conn.getCommandChannel().getInputStream());
        this.info = info;
        this.options = options;
        this.path = path;
    }

    @Override
    public Void call() throws ProxyException {
        try {
            this.out.writeByte(1);
            this.out.writeShort(111);
            this.out.writeInt(this.options);
            this.out.writeUTF(this.path);
            SerializableFileInfo sInfo = new SerializableFileInfo(this.info);
            sInfo.writeObject(this.out);
            this.out.flush();
            byte res = this.in.readByte();
            if (res != 0) {
                String errMsg = this.in.readUTF();
                System.err.println("fetchinfo command failed:" + errMsg);
                throw new ProxyException(errMsg);
            }
            return null;
        }
        catch (IOException e) {
            throw new ProxyException(e.getMessage());
        }
    }
}

