/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.preferences.ISyncFilterWidgetPatternChangeListener;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SyncFilterWidget
extends Composite {
    private static final Display display = Display.getCurrent();
    private AbstractSyncFileFilter fFilter;
    private Table fPatternTable;
    private Button fAddButton;
    private Button fUpButton;
    private Button fDownButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Set<ISyncFilterWidgetPatternChangeListener> patternChangeListeners = new HashSet<ISyncFilterWidgetPatternChangeListener>();
    private static final boolean GRAB_EXCESS = true;
    private static final boolean DEBUG = false;

    public SyncFilterWidget(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        Label patternTableLabel = new Label((Composite)this, 64);
        patternTableLabel.setText(Messages.NewSyncFileFilterPage_Patterns_to_include);
        GridData labelData = new GridData(4, 1, true, false);
        labelData.widthHint = 150;
        patternTableLabel.setLayoutData((Object)labelData);
        Composite patternTableComposite = new Composite((Composite)this, 0);
        GridLayout patternTableLayout = new GridLayout(2, false);
        patternTableComposite.setLayout((Layout)patternTableLayout);
        patternTableComposite.setLayoutData((Object)new GridData(4, 128, true, true));
        this.fPatternTable = new Table(patternTableComposite, 2818);
        this.fPatternTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
        TableColumn column = new TableColumn(this.fPatternTable, 16384, 0);
        column.setText(Messages.NewSyncFileFilterPage_Pattern);
        column = new TableColumn(this.fPatternTable, 16384, 1);
        column.setText(Messages.NewSyncFileFilterPage_Type);
        this.fPatternTable.setHeaderVisible(true);
        this.fPatternTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                SyncFilterWidget.this.editPattern();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.fPatternTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncFilterWidget.this.updateButtonEnablement();
            }
        });
        this.fAddButton = new Button(patternTableComposite, 8);
        this.fAddButton.setText(Messages.NewSyncFileFilterPage_Add);
        this.fAddButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFilterWidget.this.addPattern();
                SyncFilterWidget.this.updateButtonEnablement();
            }
        });
        this.fEditButton = new Button(patternTableComposite, 8);
        this.fEditButton.setText(Messages.NewSyncFileFilterPage_Edit);
        this.fEditButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFilterWidget.this.editPattern();
                SyncFilterWidget.this.updateButtonEnablement();
            }
        });
        this.fEditButton.setEnabled(false);
        this.fRemoveButton = new Button(patternTableComposite, 8);
        this.fRemoveButton.setText(Messages.NewSyncFileFilterPage_Remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems;
                TableItem[] tableItemArray = selectedPatternItems = SyncFilterWidget.this.fPatternTable.getSelection();
                int n = selectedPatternItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedPatternItem = tableItemArray[n2];
                    AbstractSyncFileFilter.AbstractIgnoreRule selectedRule = (AbstractSyncFileFilter.AbstractIgnoreRule)selectedPatternItem.getData();
                    SyncFilterWidget.this.fFilter.removePattern(selectedRule);
                    ++n2;
                }
                SyncFilterWidget.this.updateTable();
                SyncFilterWidget.this.updateButtonEnablement();
                SyncFilterWidget.this.notifyPatternChangeListeners();
            }
        });
        this.fRemoveButton.setEnabled(false);
        new Label(patternTableComposite, 0);
        this.fUpButton = new Button(patternTableComposite, 8);
        this.fUpButton.setText(Messages.NewSyncFileFilterPage_Move_up);
        this.fUpButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems = SyncFilterWidget.this.fPatternTable.getSelection();
                if (selectedPatternItems.length != 1) {
                    return;
                }
                int patternIndex = SyncFilterWidget.this.fPatternTable.getSelectionIndex();
                if (SyncFilterWidget.this.fFilter.promote((AbstractSyncFileFilter.AbstractIgnoreRule)selectedPatternItems[0].getData())) {
                    --patternIndex;
                }
                SyncFilterWidget.this.updateTable();
                SyncFilterWidget.this.fPatternTable.select(patternIndex);
                SyncFilterWidget.this.updateButtonEnablement();
                SyncFilterWidget.this.notifyPatternChangeListeners();
            }
        });
        this.fUpButton.setEnabled(false);
        this.fDownButton = new Button(patternTableComposite, 8);
        this.fDownButton.setText(Messages.NewSyncFileFilterPage_Move_down);
        this.fDownButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems = SyncFilterWidget.this.fPatternTable.getSelection();
                if (selectedPatternItems.length != 1) {
                    return;
                }
                int patternIndex = SyncFilterWidget.this.fPatternTable.getSelectionIndex();
                if (SyncFilterWidget.this.fFilter.demote((AbstractSyncFileFilter.AbstractIgnoreRule)selectedPatternItems[0].getData())) {
                    ++patternIndex;
                }
                SyncFilterWidget.this.updateTable();
                SyncFilterWidget.this.fPatternTable.select(patternIndex);
                SyncFilterWidget.this.updateButtonEnablement();
                SyncFilterWidget.this.notifyPatternChangeListeners();
            }
        });
        this.fDownButton.setEnabled(false);
    }

    public void addNewPatternChangeListener(ISyncFilterWidgetPatternChangeListener listener) {
        this.patternChangeListeners.add(listener);
    }

    private void addPattern() {
        SimpleEditPatternDialog dialog = new SimpleEditPatternDialog(this.fPatternTable.getShell(), null);
        if (dialog.open() == 0) {
            this.fFilter.addPattern(dialog.pattern, dialog.exclude);
            this.updateTable();
            this.notifyPatternChangeListeners();
        }
    }

    private void colorComposite(Composite comp, int color) {
    }

    private void editPattern() {
        TableItem[] selectedRuleItem = this.fPatternTable.getSelection();
        if (selectedRuleItem.length != 1) {
            return;
        }
        AbstractSyncFileFilter.AbstractIgnoreRule selectedRule = (AbstractSyncFileFilter.AbstractIgnoreRule)selectedRuleItem[0].getData();
        SimpleEditPatternDialog dialog = new SimpleEditPatternDialog(this.fPatternTable.getShell(), selectedRule);
        if (dialog.open() == 0) {
            this.fFilter.replacePattern(selectedRule, dialog.pattern, dialog.exclude);
            this.updateTable();
            this.notifyPatternChangeListeners();
        }
    }

    public AbstractSyncFileFilter getFilter() {
        return this.fFilter;
    }

    private void notifyPatternChangeListeners() {
        for (ISyncFilterWidgetPatternChangeListener listener : this.patternChangeListeners) {
            listener.patternChanged();
        }
    }

    public void removePatternChangeListener(ISyncFilterWidgetPatternChangeListener listener) {
        this.patternChangeListeners.remove(listener);
    }

    public void setFilter(AbstractSyncFileFilter filter) {
        this.fFilter = filter;
        this.updateTable();
    }

    public void update() {
        super.update();
        this.updateButtonEnablement();
        this.updateTable();
    }

    private void updateButtonEnablement() {
        this.fEditButton.setEnabled(false);
        this.fRemoveButton.setEnabled(false);
        this.fUpButton.setEnabled(false);
        this.fDownButton.setEnabled(false);
        int index = this.fPatternTable.getSelectionIndex();
        if (index >= 0) {
            this.fEditButton.setEnabled(true);
            this.fRemoveButton.setEnabled(true);
            if (index > 0) {
                this.fUpButton.setEnabled(true);
            }
            if (index < this.fPatternTable.getItemCount() - 1) {
                this.fDownButton.setEnabled(true);
            }
        }
    }

    private void updateTable() {
        this.fPatternTable.removeAll();
        for (AbstractSyncFileFilter.AbstractIgnoreRule rule : this.fFilter.getPatterns()) {
            TableItem ti = new TableItem(this.fPatternTable, 16384);
            ti.setData((Object)rule);
            String[] tableValues = new String[]{rule.getPattern(), rule.getResult() ? Messages.NewSyncFileFilterPage_exclude : Messages.NewSyncFileFilterPage_include};
            ti.setText(tableValues);
        }
        this.fPatternTable.getColumn(0).pack();
        this.fPatternTable.getColumn(1).pack();
    }

    private class SimpleEditPatternDialog
    extends Dialog {
        private AbstractSyncFileFilter.AbstractIgnoreRule oldRule;
        private boolean exclude;
        private String pattern;
        private Text patternText;
        private Label errorLabel;

        public SimpleEditPatternDialog(Shell parentShell, AbstractSyncFileFilter.AbstractIgnoreRule rule) {
            super(parentShell);
            this.oldRule = rule;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.oldRule == null) {
                shell.setText(Messages.NewSyncFileFilterPage_Add_Pattern);
            } else {
                shell.setText(Messages.NewSyncFileFilterPage_Edit_pattern);
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite main = (Composite)super.createDialogArea(parent);
            main.setLayout((Layout)new GridLayout());
            GridData data = new GridData(4, 4, true, true);
            data.widthHint = 300;
            main.setLayoutData((Object)data);
            Composite patternComp = new Composite(main, 0);
            patternComp.setLayout((Layout)new GridLayout(2, false));
            patternComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label label = new Label(patternComp, 0);
            label.setText(Messages.NewSyncFileFilterPage_Pattern_label);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.patternText = new Text(patternComp, 2048);
            this.patternText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.patternText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SimpleEditPatternDialog.this.pattern = SimpleEditPatternDialog.this.patternText.getText().trim();
                }
            });
            Group patternTypeGroup = new Group(main, 0);
            patternTypeGroup.setText(Messages.NewSyncFileFilterPage_Pattern_Type);
            patternTypeGroup.setLayout((Layout)new GridLayout(2, false));
            patternTypeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button inclusiveButton = new Button((Composite)patternTypeGroup, 16);
            inclusiveButton.setText(Messages.NewSyncFileFilterPage_Include);
            inclusiveButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            inclusiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleEditPatternDialog.this.exclude = false;
                }
            });
            Button exclusiveButton = new Button((Composite)patternTypeGroup, 16);
            exclusiveButton.setText(Messages.NewSyncFileFilterPage_Exclude);
            exclusiveButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            exclusiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleEditPatternDialog.this.exclude = true;
                }
            });
            this.errorLabel = new Label(main, 0);
            this.errorLabel.setForeground(display.getSystemColor(4));
            this.errorLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            if (this.oldRule != null) {
                this.patternText.setText(this.oldRule.getPattern());
                this.exclude = this.oldRule.getResult();
                inclusiveButton.setSelection(!this.exclude);
                exclusiveButton.setSelection(this.exclude);
            } else {
                this.exclude = true;
                inclusiveButton.setSelection(false);
                exclusiveButton.setSelection(true);
            }
            return main;
        }
    }
}

