/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.ast.util.Util;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.php.internal.ui.wizards.NewPHPTemplatesWizardPage;
import org.eclipse.php.internal.ui.wizards.PHPFileCreationWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class PHPFileCreationWizard
extends Wizard
implements INewWizard {
    protected PHPFileCreationWizardPage phpFileCreationWizardPage;
    protected ISelection selection;
    protected NewPHPTemplatesWizardPage newPhpTemplatesWizardPage;

    public PHPFileCreationWizard() {
        this.setWindowTitle(PHPUIMessages.PHPFileCreationWizard_5);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.phpFileCreationWizardPage = new PHPFileCreationWizardPage(this.selection);
        this.addPage((IWizardPage)this.phpFileCreationWizardPage);
        this.newPhpTemplatesWizardPage = new NewPHPTemplatesWizardPage();
        this.addPage((IWizardPage)this.newPhpTemplatesWizardPage);
    }

    public boolean performFinish() {
        IFile file;
        String containerName = this.phpFileCreationWizardPage.getContainerFullPath().toString();
        String fileName = this.phpFileCreationWizardPage.getFileName();
        this.newPhpTemplatesWizardPage.resetTableViewerInput();
        IScriptProject project = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(this.phpFileCreationWizardPage.getContainerFullPath());
        if (!resource.exists() || !(resource instanceof IContainer)) {
            project = DLTKCore.create((IProject)resource.getProject());
        }
        if ((file = this.phpFileCreationWizardPage.createNewFile()) == null) {
            return false;
        }
        String lineSeparator = Util.getLineSeparator(null, (IScriptProject)project);
        final PHPTemplateStore.CompiledTemplate template = this.newPhpTemplatesWizardPage.compileTemplate(containerName, fileName, lineSeparator);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        new FileCreator().createFile(PHPFileCreationWizard.this, file, monitor, template.string, template.offset);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)PHPUIMessages.PHPFileCreationWizard_0, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public IProject getProject() {
        if (this.phpFileCreationWizardPage != null) {
            return this.phpFileCreationWizardPage.getProject();
        }
        return null;
    }

    public static class FileCreator {
        public void createFile(Wizard wizard, IFile file, IProgressMonitor monitor, String contents) throws CoreException {
            this.createFile(wizard, file, monitor, contents, 0, null);
        }

        public void createFile(Wizard wizard, IFile file, IProgressMonitor monitor, String contents, int offset) throws CoreException {
            this.createFile(wizard, file, monitor, contents, offset, null);
        }

        public void createFile(Wizard wizard, final IFile file, IProgressMonitor monitor, String contents, final int offset, final String editorID) throws CoreException {
            if (file != null) {
                if (!file.isLinked()) {
                    IContainer container = file.getParent();
                    String lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{new ProjectScope(container.getProject())});
                    if (lineSeparator == null) {
                        lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{InstanceScope.INSTANCE});
                    }
                    if (lineSeparator == null) {
                        lineSeparator = System.getProperty("line.separator");
                    }
                    if (contents != null) {
                        contents = contents.replaceAll("(\n\r?|\r\n?)", lineSeparator);
                    }
                    try {
                        InputStream stream = FileCreator.openContentStream(contents, this.getCharSetValue(container));
                        if (file.exists()) {
                            file.setContents(stream, true, true, monitor);
                        } else {
                            file.create(stream, true, monitor);
                        }
                        stream.close();
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                        return;
                    }
                }
                monitor.worked(1);
                monitor.setTaskName(NLS.bind((String)PHPUIMessages.newPhpFile_openning, (Object)file.getName()));
                wizard.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            this.normalizeFile(file);
                            IEditorPart editor = editorID == null ? IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true) : IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorID, (boolean)true);
                            if (editor instanceof PHPStructuredEditor) {
                                StructuredTextViewer textViewer = ((PHPStructuredEditor)editor).getTextViewer();
                                textViewer.setSelectedRange(offset, 0);
                            }
                        }
                        catch (PartInitException partInitException) {
                            // empty catch block
                        }
                    }
                });
                monitor.worked(1);
            }
        }

        private static InputStream openContentStream(String contents, String charSet) {
            byte[] bytes;
            if (contents == null) {
                contents = "";
            }
            try {
                bytes = contents.getBytes(charSet);
            }
            catch (UnsupportedEncodingException e) {
                bytes = contents.getBytes();
            }
            return new ByteArrayInputStream(bytes);
        }

        protected String getCharSetValue(IContainer container) {
            try {
                return container.getDefaultCharset(true);
            }
            catch (CoreException e) {
                return WorkbenchEncoding.getWorkbenchDefaultEncoding();
            }
        }

        protected void normalizeFile(IFile file) {
        }
    }
}

