/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.presentation;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpThread;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.presentation.PHPModelPresentation;

public class XDebugModelPresentation
extends PHPModelPresentation
implements IDebugModelPresentation {
    @Override
    protected String getStackFrameText(IStackFrame frame) {
        if (frame instanceof DBGpStackFrame) {
            try {
                DBGpThread thread = (DBGpThread)frame.getThread();
                DBGpStackFrame topFrame = (DBGpStackFrame)thread.getTopStackFrame();
                if (topFrame != null && topFrame.equals((Object)frame)) {
                    frame = topFrame;
                }
                StringBuffer buffer = new StringBuffer();
                String frameName = frame.getName();
                if (frameName != null && frameName.length() > 0) {
                    buffer.append(frame.getName());
                    buffer.append(": lineno " + frame.getLineNumber());
                } else {
                    buffer.append(((DBGpStackFrame)frame).getSourceName());
                    buffer.append(String.valueOf(PHPDebugUIMessages.MPresentation_ATLine_1) + frame.getLineNumber());
                }
                return buffer.toString();
            }
            catch (DebugException e) {
                Logger.logException(e);
            }
        }
        return "";
    }

    @Override
    protected String getTargetText(IDebugTarget target) {
        String label = "";
        if (target.isTerminated()) {
            label = MessageFormat.format((String)PHPDebugUIMessages.MPresentation_Terminated_1, (Object[])new Object[0]);
        }
        String name = PHPDebugUIMessages.MPresentation_PHP_APP_1;
        if (target instanceof DBGpTarget || target instanceof DBGpMultiSessionTarget) {
            name = PHPDebugUIMessages.PHPModelPresentation_PHP_Applications;
            try {
                if (!target.hasThreads() && !target.isTerminated()) {
                    name = String.valueOf(name) + PHPDebugUIMessages.XDebugModelPresentation_Waiting;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return String.valueOf(label) + name;
    }
}

