/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.builtin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.server.core.builtin.IPHPRuntimeWorkingCopy;
import org.eclipse.php.internal.server.ui.builtin.Messages;
import org.eclipse.php.internal.server.ui.builtin.PHPServerUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class PHPRuntimeComposite
extends Composite {
    protected IRuntimeWorkingCopy runtimeWC;
    protected IPHPRuntimeWorkingCopy runtime;
    protected IWizardHandle wizard;
    protected Text name;
    protected List<PHPexeItem> installedExecutables;
    protected String[] executableNames;
    protected Combo combo;
    protected IInstallableRuntime ir;
    protected Job installRuntimeJob;
    protected IJobChangeListener jobListener;
    protected Label installLabel;
    protected Button install;

    protected PHPRuntimeComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Messages.wizardTitle);
        wizard.setDescription(Messages.wizardDescription);
        wizard.setImageDescriptor(PHPServerUIPlugin.getImageDescriptor("IMG_WIZ_PHP_SERVER"));
        this.createControl();
    }

    protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.runtime = (IPHPRuntimeWorkingCopy)newRuntime.loadAdapter(IPHPRuntimeWorkingCopy.class, null);
        }
        if (this.runtimeWC == null) {
            this.ir = null;
            this.install.setEnabled(false);
            this.installLabel.setText("");
        } else {
            this.ir = ServerPlugin.findInstallableRuntime((String)this.runtimeWC.getRuntimeType().getId());
            if (this.ir != null) {
                this.install.setEnabled(true);
                this.installLabel.setText(this.ir.getName());
            }
        }
        this.init();
        this.validate();
    }

    protected void createControl() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.runtimeName);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.name = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(e -> {
            this.runtimeWC.setName(this.name.getText());
            this.validate();
        });
        this.updateExecutables();
        label = new Label((Composite)this, 0);
        label.setText(Messages.installedJRE);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(this.executableNames);
        data = new GridData(256);
        this.combo.setLayoutData((Object)data);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PHPRuntimeComposite.this.updateRuntime();
                PHPRuntimeComposite.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button button = SWTUtil.createButton((Composite)this, (String)Messages.installedJREs);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = PHPRuntimeComposite.this.combo.getText();
                if (PHPRuntimeComposite.this.showPreferencePage()) {
                    PHPRuntimeComposite.this.updateExecutables();
                    PHPRuntimeComposite.this.combo.setItems(PHPRuntimeComposite.this.executableNames);
                    PHPRuntimeComposite.this.combo.setText(currentVM);
                    if (PHPRuntimeComposite.this.combo.getSelectionIndex() == -1) {
                        PHPRuntimeComposite.this.combo.select(0);
                    }
                    PHPRuntimeComposite.this.updateRuntime();
                    PHPRuntimeComposite.this.validate();
                }
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    private void updateRuntime() {
        int sel = this.combo.getSelectionIndex();
        PHPexeItem item = this.installedExecutables.get(sel);
        this.runtime.setExecutableInstall(item);
        this.runtimeWC.setLocation((IPath)new Path(item.getExecutable().getParent()));
    }

    protected void updateExecutables() {
        this.installedExecutables = new ArrayList<PHPexeItem>();
        PHPexeItem[] installedItems = PHPexes.getInstance().getAllItems();
        int size = installedItems.length;
        int i = 0;
        while (i < size) {
            this.installedExecutables.add(installedItems[i]);
            ++i;
        }
        size = this.installedExecutables.size();
        this.executableNames = new String[size];
        i = 0;
        while (i < size) {
            PHPexeItem vmInstall = this.installedExecutables.get(i);
            this.executableNames[i] = vmInstall.getName();
            ++i;
        }
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.php.ui.preferences.PHPBasePreferencePage").findSubNode(id);
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager2);
        dialog.create();
        return dialog.open() == 0;
    }

    protected void init() {
        if (this.name == null || this.runtime == null) {
            return;
        }
        if (this.runtimeWC.getName() != null) {
            this.name.setText(this.runtimeWC.getName());
        } else {
            this.name.setText("");
        }
        int size = this.installedExecutables.size();
        int i = 0;
        while (i < size) {
            PHPexeItem item = this.installedExecutables.get(i);
            if (item.equals(this.runtime.getExecutableInstall())) {
                this.combo.select(i);
            }
            ++i;
        }
    }

    protected void validate() {
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        IStatus status = this.runtimeWC.validate(null);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }

    public void dispose() {
        super.dispose();
        if (this.installRuntimeJob != null) {
            this.installRuntimeJob.removeJobChangeListener(this.jobListener);
        }
    }
}

