/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.file;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess;

public class ProjectBasedFileAccess
implements IPFileSystemAccess {
    IProject project;
    String subFolderName;
    static final boolean force = true;

    public ProjectBasedFileAccess(IProject project) {
        this.setProject(project, null);
    }

    public ProjectBasedFileAccess(IProject project, String subFolderName) {
        this.setProject(project, subFolderName);
    }

    public void setProject(IProject project) {
        this.setProject(project, null);
    }

    public void setProject(IProject project, String subFolderName) {
        this.project = project;
        this.subFolderName = subFolderName;
    }

    @Override
    public void generateFile(String fileName, String content) {
        IFile file = this.getFile(fileName);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
        try {
            if (file.exists()) {
                file.setContents((InputStream)contentStream, true, true, null);
            } else {
                file.create((InputStream)contentStream, true, null);
            }
            file.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteFile(String fileName) {
        IFile file = this.getFile(fileName);
        try {
            if (file.exists()) {
                file.delete(true, null);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public IFile getFile(String filename) {
        String[] paths = filename.split("/");
        IContainer packageContainer = this.getFolder((IContainer)this.project, this.subFolderName);
        try {
            int i = 0;
            while (i < paths.length - 1) {
                String path = paths[i];
                if (!(packageContainer = this.getFolder(packageContainer, path)).exists()) {
                    ((IFolder)packageContainer).create(false, true, null);
                }
                ++i;
            }
            String last = paths[paths.length - 1];
            return this.getFile(packageContainer, last);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public IContainer getFolder(IContainer container, String folderName) {
        if (folderName == null) {
            return container;
        }
        if (container instanceof IFolder) {
            return ((IFolder)container).getFolder(folderName);
        }
        if (container instanceof IProject) {
            return ((IProject)container).getFolder(folderName);
        }
        return null;
    }

    public IFile getFile(IContainer container, String fileName) {
        if (container instanceof IFolder) {
            return ((IFolder)container).getFile(fileName);
        }
        if (container instanceof IProject) {
            return ((IProject)container).getFile(fileName);
        }
        return null;
    }
}

