/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import org.eclipse.core.internal.preferences.AbstractScope;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PapyrusProjectScope
extends AbstractScope {
    public static final String SCOPE = "papyrusProject";
    private String papyrusProjectName;
    private IProject context;

    public PapyrusProjectScope(IProject project, String papyrusProjectName) {
        this.context = project;
        this.papyrusProjectName = papyrusProjectName;
    }

    public IEclipsePreferences getNode(String qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder node = new StringBuilder(this.context.getName());
        node.append("/");
        node.append(this.papyrusProjectName);
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node(SCOPE).node(node.toString()).node(qualifier);
    }

    public String getName() {
        return SCOPE;
    }

    public IPath getLocation() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PapyrusProjectScope)) {
            return false;
        }
        PapyrusProjectScope other = (PapyrusProjectScope)((Object)obj);
        return this.context.equals((Object)other.context) && this.papyrusProjectName.equals(other.papyrusProjectName);
    }

    public int hashCode() {
        return super.hashCode() + this.context.getFullPath().hashCode() + "/".hashCode() + this.papyrusProjectName.hashCode();
    }
}

