/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources.backend;

import java.util.Queue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.internal.resources.ResourcesPlugin;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.resources.backend.BackendException;
import org.eclipse.oomph.resources.backend.BackendFile;
import org.eclipse.oomph.resources.backend.BackendFolder;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.resources.backend.BackendSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BackendContainer
extends BackendResource {
    BackendContainer(BackendSystem system, URI systemRelativeURI) {
        super(system, systemRelativeURI);
    }

    public final BackendResource[] getMembers(IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BackendSystem system = this.getSystem();
            return system.getMembers(this, monitor);
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public final BackendResource findMember(URI relativeURI, IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        if (relativeURI.isEmpty()) {
            return this;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BackendSystem system = this.getSystem();
            return system.findMember(this, relativeURI, monitor);
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public final BackendResource findMember(String relativePath, IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        return this.findMember(URI.createURI((String)relativePath), monitor);
    }

    public final BackendResource findMember(IPath relativePath, IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        return this.findMember(relativePath.toString(), monitor);
    }

    public final BackendFolder getFolder(URI relativeURI) throws BackendException {
        URI systemRelativeURI = this.getSystemRelativeURI().appendSegments(relativeURI.segments());
        return new BackendFolder(this.getSystem(), systemRelativeURI);
    }

    public final BackendFolder getFolder(String relativePath) throws BackendException {
        return this.getFolder(URI.createURI((String)relativePath));
    }

    public final BackendFolder getFolder(IPath relativePath) throws BackendException {
        return this.getFolder(relativePath.toString());
    }

    public final BackendFile getFile(URI relativeURI) throws BackendException {
        URI systemRelativeURI = this.getSystemRelativeURI().appendSegments(relativeURI.segments());
        return new BackendFile(this.getSystem(), systemRelativeURI);
    }

    public final BackendFile getFile(String relativePath) throws BackendException {
        return this.getFile(URI.createURI((String)relativePath));
    }

    public final BackendFile getFile(IPath relativePath) throws BackendException {
        return this.getFile(relativePath.toString());
    }

    public final ResourcesUtil.ImportResult importIntoWorkspace(IProject project, IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BackendSystem system = this.getSystem();
            return system.importIntoWorkspace(this, project, monitor);
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    @Override
    final void visit(Queue<BackendResource> queue, BackendResource.Visitor visitor, IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (this.doVisit(this, visitor, (IProgressMonitor)progress.newChild(1))) {
            BackendResource[] backendResourceArray = this.getMembers((IProgressMonitor)progress.newChild(1));
            int n = backendResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                BackendResource member = backendResourceArray[n2];
                ResourcesPlugin.checkCancelation((IProgressMonitor)monitor);
                queue.add(member);
                ++n2;
            }
        }
        progress.done();
    }

    protected abstract boolean doVisit(BackendContainer var1, BackendResource.Visitor var2, IProgressMonitor var3) throws BackendException, OperationCanceledException;
}

