/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.asm.AsmBoundClass;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class AddImplicitActivationAdapter
extends ClassVisitor {
    public static final Object ANNOTATION_IMPLICIT_ACTIVATION = String.valueOf('L') + ClassNames.IMPLICIT_ACTIVATION + ';';
    protected static final String TARGET_CLASS_NAME = ClassNames.ITEAM_SLASH;
    protected static final String IMPLICIT_ACTIVATE_METHOD_NAME = "_OT$implicitlyActivate";
    protected static final String IMPLICIT_DEACTIVATE_METHOD_NAME = "_OT$implicitlyDeactivate";
    protected static final String METHOD_DESC = "()V";
    private static ImplicitActivationMode implicitActivationMode = ImplicitActivationMode.ANNOTATED;
    private AsmBoundClass clazz;

    static {
        String prop = System.getProperty("ot.implicit.team.activation");
        ImplicitActivationMode[] implicitActivationModeArray = ImplicitActivationMode.values();
        int n = implicitActivationModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImplicitActivationMode mode = implicitActivationModeArray[n2];
            if (mode.name().equals(prop)) {
                implicitActivationMode = mode;
                break;
            }
            ++n2;
        }
    }

    public AddImplicitActivationAdapter(ClassVisitor cv, AsmBoundClass clazz) {
        super(327680, cv);
        this.clazz = clazz;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.isCandidateForImplicitActivation(name, desc, access)) {
            final MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, null, null);
            final String enclTeamDesc = this.clazz.isRole() ? String.valueOf('L') + this.clazz.getEnclosingClass().getName().replace('.', '/') + ';' : null;
            final int nesting = this.clazz.nestingDepth() - 1;
            return new AdviceAdapter(this.api, methodVisitor, access, name, desc){

                protected void onMethodEnter() {
                    if (AddImplicitActivationAdapter.this.clazz.isTeam()) {
                        methodVisitor.visitIntInsn(25, 0);
                        methodVisitor.visitMethodInsn(185, TARGET_CLASS_NAME, AddImplicitActivationAdapter.IMPLICIT_ACTIVATE_METHOD_NAME, AddImplicitActivationAdapter.METHOD_DESC, true);
                    }
                    if (AddImplicitActivationAdapter.this.clazz.isRole()) {
                        methodVisitor.visitIntInsn(25, 0);
                        methodVisitor.visitFieldInsn(180, AddImplicitActivationAdapter.this.clazz.getName().replace('.', '/'), "this$" + nesting, enclTeamDesc);
                        methodVisitor.visitMethodInsn(185, TARGET_CLASS_NAME, AddImplicitActivationAdapter.IMPLICIT_ACTIVATE_METHOD_NAME, AddImplicitActivationAdapter.METHOD_DESC, true);
                    }
                }

                protected void onMethodExit(int opcode) {
                    if (AddImplicitActivationAdapter.this.clazz.isTeam()) {
                        methodVisitor.visitIntInsn(25, 0);
                        methodVisitor.visitMethodInsn(185, TARGET_CLASS_NAME, AddImplicitActivationAdapter.IMPLICIT_DEACTIVATE_METHOD_NAME, AddImplicitActivationAdapter.METHOD_DESC, true);
                    }
                    if (AddImplicitActivationAdapter.this.clazz.isRole()) {
                        methodVisitor.visitIntInsn(25, 0);
                        methodVisitor.visitFieldInsn(180, AddImplicitActivationAdapter.this.clazz.getName().replace('.', '/'), "this$" + nesting, enclTeamDesc);
                        methodVisitor.visitMethodInsn(185, TARGET_CLASS_NAME, AddImplicitActivationAdapter.IMPLICIT_DEACTIVATE_METHOD_NAME, AddImplicitActivationAdapter.METHOD_DESC, true);
                    }
                }

                public void endMethod() {
                    if (AddImplicitActivationAdapter.this.clazz.isTeam() || AddImplicitActivationAdapter.this.clazz.isRole()) {
                        methodVisitor.visitMaxs(0, 0);
                    }
                }
            };
        }
        return null;
    }

    private boolean isCandidateForImplicitActivation(String methName, String methDesc, int accessFlags) {
        boolean methodIsAccessible = true;
        if (this.clazz.isTeam()) {
            if ((accessFlags & 2) != 0) {
                methodIsAccessible = false;
            }
        } else if (this.clazz.isRole()) {
            if (this.clazz.isProtected()) {
                return false;
            }
            if ((accessFlags & 1) == 0) {
                methodIsAccessible = false;
            }
        } else {
            return false;
        }
        switch (implicitActivationMode) {
            case NEVER: {
                return false;
            }
            case ANNOTATED: {
                if (!this.clazz.hasMethodImplicitActivation(String.valueOf(methName) + methDesc, methodIsAccessible)) {
                    return false;
                }
            }
            case ALWAYS: {
                return AddImplicitActivationAdapter.canImplicitlyActivate(accessFlags, methName, methDesc);
            }
        }
        return false;
    }

    private static boolean canImplicitlyActivate(int methFlags, String methName, String methDesc) {
        boolean isCandidate = !((methFlags & 0x408) != 0 || methName.startsWith("_OT$") || methName.equals("<init>") || methName.equals("activate") && methDesc.equals(METHOD_DESC) || methName.equals("deactivate") && methDesc.equals(METHOD_DESC) || ConstantMembers.isReflectiveOTMethod(methName, methDesc));
        return isCandidate;
    }

    private static enum ImplicitActivationMode {
        NEVER,
        ANNOTATED,
        ALWAYS;

    }
}

