/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.compare;

import java.io.UnsupportedEncodingException;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.SharedDocumentAdapterWrapper;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.texteditor.IDocumentProvider;

class RoleMethodNode
extends DocumentRangeNode
implements ITypedElement {
    public static final int CU = 0;
    public static final int METHOD = 11;
    private static final String COMPILATION_UNIT = "compilationUnit";
    private static final char METHOD_ID = '~';
    private static final char COMPILATIONUNIT = '{';

    static String buildID(int type, String name) {
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case 0: {
                sb.append('{');
                break;
            }
            case 11: {
                sb.append('~');
                sb.append(name);
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
            }
        }
        return sb.toString();
    }

    public RoleMethodNode(RoleMethodNode parent, int type, String name, int start, int length) {
        super((DocumentRangeNode)parent, type, RoleMethodNode.buildID(type, name), parent.getDocument(), start, length);
        parent.addChild(this);
    }

    public RoleMethodNode(IDocument document) {
        super(0, RoleMethodNode.buildID(0, "root"), document, 0, document.getLength());
    }

    public String getName() {
        switch (this.getTypeCode()) {
            case 0: {
                return COMPILATION_UNIT;
            }
        }
        return this.getId().substring(1);
    }

    public String getType() {
        return "java2";
    }

    public Image getImage() {
        return null;
    }

    public String toString() {
        return String.valueOf(this.getType()) + ": " + this.getName() + "[" + this.getRange().offset + "+" + this.getRange().length + "]";
    }

    static class RootJavaNode
    extends RoleMethodNode
    implements IDisposable {
        private final Object fInput;
        private final ISharedDocumentAdapter fAdapter;

        RootJavaNode(IDocument document, Object input, ISharedDocumentAdapter adapter) {
            super(document);
            this.fInput = input;
            this.fAdapter = adapter;
        }

        public boolean isEditable() {
            return true;
        }

        protected void nodeChanged(DocumentRangeNode node) {
            this.save((IStructureComparator)this, this.fInput);
        }

        void save(IStructureComparator node, Object input) {
            if (node instanceof IDocumentRange && input instanceof IEditableContent) {
                byte[] bytes;
                IDocument providerDoc;
                IDocumentProvider provider;
                IEditorInput key;
                IDocument document = ((IDocumentRange)node).getDocument();
                ISharedDocumentAdapter sda = SharedDocumentAdapterWrapper.getAdapter((Object)input);
                if (sda != null && (key = sda.getDocumentKey(input)) != null && (provider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)key)) != null && (providerDoc = provider.getDocument((Object)key)) != null && providerDoc == document && this.save(provider, document, input, sda, key)) {
                    return;
                }
                IEditableContent bca = (IEditableContent)input;
                String contents = document.get();
                String encoding = null;
                if (input instanceof IEncodedStreamContentAccessor) {
                    try {
                        encoding = ((IEncodedStreamContentAccessor)input).getCharset();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                if (encoding == null) {
                    encoding = ResourcesPlugin.getEncoding();
                }
                try {
                    bytes = contents.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    bytes = contents.getBytes();
                }
                bca.setContent(bytes);
            }
        }

        boolean save(IDocumentProvider provider, IDocument document, Object input, ISharedDocumentAdapter sda, IEditorInput key) {
            try {
                sda.flushDocument(provider, key, document, false);
                return true;
            }
            catch (CoreException e) {
                OTDTUIPlugin.log(e);
                return false;
            }
        }

        public void dispose() {
            if (this.fAdapter != null) {
                this.fAdapter.disconnect(this.fInput);
            }
        }

        public Object getAdapter(Class adapter) {
            if (adapter == ISharedDocumentAdapter.class) {
                return this.fAdapter;
            }
            return super.getAdapter(adapter);
        }

        public boolean isReadOnly() {
            if (this.fInput instanceof IEditableContentExtension) {
                IEditableContentExtension ext = (IEditableContentExtension)this.fInput;
                return ext.isReadOnly();
            }
            return super.isReadOnly();
        }

        public IStatus validateEdit(Shell shell) {
            if (this.fInput instanceof IEditableContentExtension) {
                IEditableContentExtension ext = (IEditableContentExtension)this.fInput;
                return ext.validateEdit(shell);
            }
            return super.validateEdit(shell);
        }
    }
}

