/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.bindingeditor;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RadioButtonComposite
extends Composite {
    Button _oldSelectedButton;

    public RadioButtonComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void doRadioButtonBehavior(Button selectedButton) {
        if (this._oldSelectedButton != null && this._oldSelectedButton.equals(selectedButton)) {
            selectedButton.setSelection(true);
            this._oldSelectedButton = selectedButton;
            return;
        }
        Button[] radioButtons = this.getButtons();
        int idx = 0;
        while (idx < radioButtons.length) {
            if (!radioButtons[idx].equals(selectedButton)) {
                radioButtons[idx].setSelection(false);
            }
            ++idx;
        }
        this._oldSelectedButton = selectedButton;
    }

    public Button getSelectedButton() {
        Button[] radioButtons = this.getButtons();
        int idx = 0;
        while (idx < radioButtons.length) {
            if (radioButtons[idx].getSelection()) {
                return radioButtons[idx];
            }
            ++idx;
        }
        return null;
    }

    public void setSelectionButton(Button button) {
        Button[] radioButtons = this.getButtons();
        int idx = 0;
        while (idx < radioButtons.length) {
            if (radioButtons[idx].equals(button)) {
                radioButtons[idx].setSelection(true);
                this._oldSelectedButton = button;
            } else {
                radioButtons[idx].setSelection(false);
            }
            ++idx;
        }
    }

    public void removeSelectionButton(Button button) {
        Button[] radioButtons = this.getButtons();
        int idx = 0;
        while (idx < radioButtons.length) {
            if (radioButtons[idx].equals(button) && radioButtons[idx].getSelection()) {
                radioButtons[idx].setSelection(false);
                this._oldSelectedButton = null;
            }
            ++idx;
        }
    }

    public void deselectAll() {
        Button[] radioButtons = this.getButtons();
        int idx = 0;
        while (idx < radioButtons.length) {
            if (radioButtons[idx].getSelection()) {
                radioButtons[idx].setSelection(false);
            }
            ++idx;
        }
    }

    public void enableAll() {
        Button[] radioButtons = this.getButtons();
        int idx = 0;
        while (idx < radioButtons.length) {
            if (!radioButtons[idx].isEnabled()) {
                radioButtons[idx].setEnabled(true);
            }
            ++idx;
        }
    }

    public void disableAll() {
        Button[] radioButtons = this.getButtons();
        int idx = 0;
        while (idx < radioButtons.length) {
            if (radioButtons[idx].isEnabled()) {
                radioButtons[idx].setEnabled(false);
            }
            ++idx;
        }
    }

    private Button[] getButtons() {
        Control[] controls = this.getChildren();
        ArrayList<Button> buttons = new ArrayList<Button>();
        int idx = 0;
        while (idx < controls.length) {
            if (controls[idx] instanceof Button) {
                buttons.add((Button)controls[idx]);
            }
            ++idx;
        }
        return buttons.toArray(new Button[buttons.size()]);
    }
}

