/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.concurrent.Timeouter;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class TimeoutMonitor
extends Monitor {
    private long timeout;
    private transient Timeouter timeouter;

    public TimeoutMonitor(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        if (this.timeouter != null) {
            this.timeouter.setTimeout(timeout);
        }
    }

    public void touch() {
        if (this.timeouter != null) {
            this.timeouter.touch();
        }
    }

    public OMMonitor begin(double totalWork) {
        this.timeouter = new Timeouter(this.getTimer(), this.timeout){

            protected void handleTimeout(long untouched) {
                TimeoutMonitor.this.handleTimeout(untouched);
            }
        };
        this.touch();
        super.begin(totalWork);
        return this;
    }

    public void worked(double work) {
        this.touch();
        super.worked(work);
    }

    public OMMonitor fork(double work) {
        this.touch();
        return super.fork(work);
    }

    public OMMonitor.Async forkAsync(double work) {
        this.touch();
        return super.forkAsync(work);
    }

    public void done() {
        this.cancelTimeouter();
        super.done();
    }

    public void cancel(RuntimeException cancelException) {
        this.cancelTimeouter();
        super.cancel(cancelException);
    }

    public boolean isCanceled() {
        this.touch();
        return super.isCanceled();
    }

    public void checkCanceled() throws MonitorCanceledException {
        this.touch();
        super.checkCanceled();
    }

    protected void handleTimeout(long untouched) {
        this.cancel(new TimeoutRuntimeException("Timeout after " + untouched + " millis"));
    }

    private void cancelTimeouter() {
        if (this.timeouter != null) {
            this.timeouter.dispose();
            this.timeouter = null;
        }
    }
}

