/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSIncompleteCompletionProposal;
import org.eclipse.lsp4j.CompletionItem;

public class LSCompletionProposal
extends LSIncompleteCompletionProposal
implements ICompletionProposalExtension,
ICompletionProposalExtension2 {
    public LSCompletionProposal(@NonNull CompletionItem item, int offset, LanguageServiceAccessor.LSPDocumentInfo info) {
        super(item, offset, info);
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        this.viewer = viewer;
    }

    public void unselected(ITextViewer viewer) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (this.item.getLabel() == null) return false;
        if (this.item.getLabel().isEmpty()) {
            return false;
        }
        if (offset < this.bestOffset) {
            return false;
        }
        try {
            String subString = document.get(this.bestOffset, offset - this.bestOffset);
            String insert = this.getInsertText();
            if (this.item.getTextEdit() != null) {
                int start = LSPEclipseUtils.toOffset(this.item.getTextEdit().getRange().getStart(), document);
                int end = offset;
                subString = document.get(start, end - start);
                insert = this.item.getTextEdit().getNewText();
            }
            int lastIndex = 0;
            insert = insert.toLowerCase();
            subString = subString.toLowerCase();
            char[] cArray = subString.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Character c = Character.valueOf(cArray[n2]);
                int index = insert.indexOf(c.charValue(), lastIndex);
                if (index < 0) {
                    return false;
                }
                lastIndex = index + 1;
                ++n2;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return true;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.viewer = viewer;
        this.apply(viewer.getDocument(), trigger, stateMask, offset);
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.apply(document, trigger, 0, offset);
    }

    @Override
    public void apply(IDocument document) {
        this.apply(document, '\u0000', 0, this.bestOffset);
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return 131072;
    }
}

