/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.buildpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.wizards.IBuildpathContainerPage;
import org.eclipse.dltk.internal.ui.wizards.IBuildpathContainerPageExtension2;
import org.eclipse.dltk.ui.wizards.IBuildpathContainerPageExtension;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathUtil;
import org.eclipse.ldt.ui.LuaExecutionEnvironmentUIManager;
import org.eclipse.ldt.ui.SWTUtil;
import org.eclipse.ldt.ui.internal.Activator;
import org.eclipse.ldt.ui.internal.buildpath.LuaExecutionEnvironmentContentProvider;
import org.eclipse.ldt.ui.internal.buildpath.LuaExecutionEnvironmentLabelProvider;
import org.eclipse.ldt.ui.internal.buildpath.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LuaExecutionEnvironmentWizardPage
extends NewElementWizardPage
implements IBuildpathContainerPage,
IBuildpathContainerPageExtension,
IBuildpathContainerPageExtension2 {
    private TreeViewer eeTreeViewer;
    private Button configureEE;
    private ArrayList<LuaExecutionEnvironment> currentEEs;

    public LuaExecutionEnvironmentWizardPage() {
        super("LuaExecutionEnvironmentWizardPage");
        this.setTitle(Messages.LuaExecutionEnvironmentWizardPageTitle);
        this.setDescription(Messages.LuaExecutionEnvironmentWizardPageDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.eeTreeViewer = new TreeViewer(composite, 2820);
        this.eeTreeViewer.setContentProvider((IContentProvider)new LuaExecutionEnvironmentContentProvider());
        this.eeTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LuaExecutionEnvironmentLabelProvider()));
        this.updateExecutionEnvironmentList();
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.eeTreeViewer.getControl());
        this.configureEE = new Button(composite, 8);
        this.configureEE.setText(Messages.LuaExecutionEnvironmentWizardPageConfigureButtonLabel);
        int horizontalHint = SWTUtil.getButtonWidthHint(this.configureEE);
        GridDataFactory.swtDefaults().align(0x1000008, 1).hint(horizontalHint, -1).applyTo((Control)this.configureEE);
        this.init();
        this.addListeners();
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    private void init() {
        this.updateExecutionEnvironmentList();
    }

    private void addListeners() {
        this.configureEE.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)LuaExecutionEnvironmentWizardPage.this.getShell(), (String)"org.eclipse.ldt.ui.executionenvironmentpreferencepage", (String[])new String[]{"org.eclipse.ldt.ui.executionenvironmentpreferencepage"}, null).open();
                LuaExecutionEnvironmentWizardPage.this.updateExecutionEnvironmentList();
                LuaExecutionEnvironmentWizardPage.this.setPageComplete(LuaExecutionEnvironmentWizardPage.this.validatePage());
            }
        });
        this.eeTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LuaExecutionEnvironmentWizardPage.this.setPageComplete(LuaExecutionEnvironmentWizardPage.this.validatePage());
            }
        });
    }

    public IBuildpathEntry[] getNewContainers() {
        LuaExecutionEnvironment selectedExecutionEnvironment = this.getSelectedExecutionEnvironment();
        if (selectedExecutionEnvironment != null) {
            IPath path = LuaExecutionEnvironmentBuildpathUtil.getLuaExecutionEnvironmentContainerPath((LuaExecutionEnvironment)selectedExecutionEnvironment);
            IBuildpathEntry buildpathContainerEntry = DLTKCore.newContainerEntry((IPath)path);
            return new IBuildpathEntry[]{buildpathContainerEntry};
        }
        return new IBuildpathEntry[0];
    }

    public boolean finish() {
        return true;
    }

    private void updateExecutionEnvironmentList() {
        block6: {
            List<LuaExecutionEnvironment> newInput;
            List oldInput;
            block5: {
                if (this.eeTreeViewer == null) {
                    return;
                }
                oldInput = null;
                if (this.eeTreeViewer.getInput() instanceof List) {
                    oldInput = (List)this.eeTreeViewer.getInput();
                }
                newInput = LuaExecutionEnvironmentUIManager.getAvailableExecutionEnvironments();
                if (this.currentEEs != null) {
                    newInput.removeAll(this.currentEEs);
                }
                this.eeTreeViewer.setInput(newInput);
                if (oldInput != null && !oldInput.isEmpty()) break block5;
                if (newInput == null || newInput.isEmpty()) break block6;
                this.eeTreeViewer.setSelection((ISelection)new StructuredSelection((Object)newInput.get(0)));
                break block6;
            }
            if (!oldInput.equals(newInput)) {
                for (LuaExecutionEnvironment ee : newInput) {
                    if (oldInput.contains(ee)) continue;
                    this.eeTreeViewer.setSelection((ISelection)new StructuredSelection((Object)ee));
                    break;
                }
            }
        }
    }

    private LuaExecutionEnvironment getSelectedExecutionEnvironment() {
        if (this.eeTreeViewer == null) {
            return null;
        }
        ISelection selection = this.eeTreeViewer.getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        return (LuaExecutionEnvironment)((IStructuredSelection)selection).getFirstElement();
    }

    private boolean validatePage() {
        return this.getSelectedExecutionEnvironment() != null;
    }

    protected void updateStatus(IStatus status) {
    }

    public IBuildpathEntry getSelection() {
        return null;
    }

    public void setSelection(IBuildpathEntry containerEntry) {
    }

    public void initialize(IScriptProject project, IBuildpathEntry[] currentEntries) {
        this.currentEEs = new ArrayList();
        IBuildpathEntry[] iBuildpathEntryArray = currentEntries;
        int n = currentEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            LuaExecutionEnvironment executionEnvironment = null;
            try {
                executionEnvironment = LuaExecutionEnvironmentBuildpathUtil.getExecutionEnvironment((IPath)entry.getPath());
            }
            catch (CoreException e) {
                Activator.logWarning(NLS.bind((String)"Unable to get execution environement for the path {0}.", (Object)entry.getPath(), (Object)((Object)e)));
            }
            if (executionEnvironment != null) {
                this.currentEEs.add(executionEnvironment);
            }
            ++n2;
        }
        if (!this.currentEEs.isEmpty()) {
            this.setMessage(Messages.LuaExecutionEnvironmentWizardPage_warning_several_ee, 2);
        }
    }
}

