/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.target;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.target.ILaunchTargetUIManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.registry.WizardsRegistryReader;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class LaunchTargetUIManager
implements ILaunchTargetUIManager {
    private Map<String, IConfigurationElement> typeElements;
    private Map<String, ILabelProvider> labelProviders = new HashMap<String, ILabelProvider>();
    private IWizardDescriptor[] wizards;

    @Override
    public synchronized ILabelProvider getLabelProvider(ILaunchTarget target) {
        String typeId;
        Object labelProvider;
        if (this.typeElements == null) {
            this.typeElements = new HashMap<String, IConfigurationElement>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".launchTargetTypeUI");
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String id = element.getAttribute("id");
                    if (id != null) {
                        this.typeElements.put(id, element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if ((labelProvider = this.labelProviders.get(typeId = target.getTypeId())) == null) {
            IConfigurationElement element = this.typeElements.get(typeId);
            if (element != null) {
                try {
                    labelProvider = (ILabelProvider)element.createExecutableExtension("labelProvider");
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
            if (labelProvider == null) {
                labelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof ILaunchTarget) {
                            return ((ILaunchTarget)element).getId();
                        }
                        return super.getText(element);
                    }

                    public Image getImage(Object element) {
                        if (element instanceof ILaunchTarget) {
                            return Activator.getDefault().getImage("localTarget");
                        }
                        return super.getImage(element);
                    }
                };
            }
        }
        return labelProvider;
    }

    @Override
    public synchronized IWizardDescriptor[] getLaunchTargetWizards() {
        if (this.wizards != null) {
            return this.wizards;
        }
        WizardsRegistryReader reader = new WizardsRegistryReader("org.eclipse.launchbar.ui", "launchTargetTypeUI");
        WizardCollectionElement wizardElements = reader.getWizardElements();
        List<IWizardDescriptor> result = this.collectWizards(wizardElements, new ArrayList<IWizardDescriptor>());
        this.wizards = result.toArray(new IWizardDescriptor[result.size()]);
        return this.wizards;
    }

    private List<IWizardDescriptor> collectWizards(WizardCollectionElement element, List<IWizardDescriptor> result) {
        IWizardDescriptor[] wizards;
        Object[] children = element.getChildren(null);
        Object[] objectArray = wizards = element.getWizards();
        int n = wizards.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor desc = objectArray[n2];
            result.add(desc);
            ++n2;
        }
        objectArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            IWizardDescriptor cat = objectArray[n2];
            WizardCollectionElement category = (WizardCollectionElement)cat;
            this.collectWizards(category, result);
            ++n2;
        }
        return result;
    }
}

