/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.adaptable;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.rc.common.adaptable.IAdapterFactory;
import org.eclipse.jubula.rc.common.classloader.DefaultUrlLocator;
import org.eclipse.jubula.rc.common.classloader.IUrlLocator;
import org.eclipse.jubula.tools.internal.utils.ClassPathHacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterFactoryRegistry {
    public static final String ADAPTER_PACKAGE_NAME = "org.eclipse.jubula.rc.common.adapter";
    public static final String EXT_ADAPTER_PACKAGE_NAME = "org.eclipse.jubula.ext.rc.common.adapter";
    private static Logger log = LoggerFactory.getLogger(AdapterFactoryRegistry.class);
    private static AdapterFactoryRegistry instance = new AdapterFactoryRegistry();
    private Map<Class, Collection<IAdapterFactory>> m_registrationMap = new HashMap<Class, Collection<IAdapterFactory>>();

    private AdapterFactoryRegistry() {
    }

    public static AdapterFactoryRegistry getInstance() {
        return instance;
    }

    public void registerFactory(IAdapterFactory factory) {
        Class[] supportedClasses = factory.getSupportedClasses();
        int i = 0;
        while (i < supportedClasses.length) {
            Collection<IAdapterFactory> registeredFactories = this.m_registrationMap.get(supportedClasses[i]);
            if (registeredFactories == null) {
                registeredFactories = new HashSet<IAdapterFactory>();
            }
            registeredFactories.add(factory);
            this.m_registrationMap.put(supportedClasses[i], registeredFactories);
            ++i;
        }
    }

    public void signOffFactory(IAdapterFactory factory) {
        Class[] supportedClasses = factory.getSupportedClasses();
        int i = 0;
        while (i < supportedClasses.length) {
            Class supportedClass = supportedClasses[i];
            Collection<IAdapterFactory> registeredFactories = this.m_registrationMap.get(supportedClass);
            if (registeredFactories == null) {
                return;
            }
            registeredFactories.remove(factory);
            this.m_registrationMap.remove(supportedClass);
            ++i;
        }
    }

    public Object getAdapter(Class targetAdapterClass, Object objectToAdapt) {
        if (objectToAdapt == null) {
            return null;
        }
        Collection<IAdapterFactory> registeredFactories = null;
        Class<?> superClass = objectToAdapt.getClass();
        while (registeredFactories == null && superClass != Object.class) {
            registeredFactories = this.m_registrationMap.get(superClass);
            superClass = superClass.getSuperclass();
        }
        if (registeredFactories == null) {
            return null;
        }
        for (IAdapterFactory adapterFactory : registeredFactories) {
            Object object = adapterFactory.getAdapter(targetAdapterClass, objectToAdapt);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static void initRegistration(IUrlLocator urlLocator) {
        Class[] adapterFactories = AdapterFactoryRegistry.findClassesOfType(urlLocator, ADAPTER_PACKAGE_NAME, IAdapterFactory.class);
        Class[] externalAdapterFactories = AdapterFactoryRegistry.findClassesOfType(urlLocator, EXT_ADAPTER_PACKAGE_NAME, IAdapterFactory.class);
        ArrayList<Class> allFactories = new ArrayList<Class>(Arrays.asList(adapterFactories));
        allFactories.addAll(Arrays.asList(externalAdapterFactories));
        for (Class c : allFactories) {
            try {
                IAdapterFactory factory = (IAdapterFactory)c.newInstance();
                AdapterFactoryRegistry.getInstance().registerFactory(factory);
            }
            catch (IllegalAccessException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static void initRegistration() {
        AdapterFactoryRegistry.initRegistration(new DefaultUrlLocator());
    }

    private static Class[] findClassesOfType(IUrlLocator urlLocator, String packageName, Class<IAdapterFactory> superclass) {
        try {
            Class[] allClasses = AdapterFactoryRegistry.getClasses(urlLocator, packageName);
            ArrayList<Class> assignableClasses = new ArrayList<Class>();
            int i = 0;
            while (i < allClasses.length) {
                if (superclass.isAssignableFrom(allClasses[i]) && superclass != allClasses[i]) {
                    assignableClasses.add(allClasses[i]);
                }
                ++i;
            }
            return AdapterFactoryRegistry.castListToClassArray(assignableClasses);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Class[0];
        }
        catch (IOException iOException) {
            return new Class[0];
        }
    }

    private static Class[] castListToClassArray(List<Class> classes) {
        Class[] arrayClasses = new Class[classes.size()];
        int i = 0;
        while (i < arrayClasses.length) {
            arrayClasses[i] = classes.get(i);
            ++i;
        }
        return arrayClasses;
    }

    private static Class[] getClasses(IUrlLocator urlLocator, String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = AdapterFactoryRegistry.class.getClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<URL> dirs = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            try {
                resource = urlLocator.convertUrl(resource);
                dirs.add(resource);
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        int i = 0;
        while (i < dirs.size()) {
            if (((URL)dirs.get(i)).toString().startsWith("jar:")) {
                classes.addAll(ClassPathHacker.findClassesInJar((URL)((URL)dirs.get(i)), (String)packageName, (ClassLoader)classLoader));
            } else {
                classes.addAll(ClassPathHacker.findClasses((URL)((URL)dirs.get(i)), (String)packageName));
            }
            ++i;
        }
        return AdapterFactoryRegistry.castListToClassArray(classes);
    }

    public boolean isRegistered(IAdapterFactory factory) {
        Class[] supportedClasses = factory.getSupportedClasses();
        int i = 0;
        while (i < supportedClasses.length) {
            Class supportedClass = supportedClasses[i];
            Collection<IAdapterFactory> registeredFactories = this.m_registrationMap.get(supportedClass);
            if (registeredFactories == null) {
                return false;
            }
            for (IAdapterFactory iAdapterFactory : registeredFactories) {
                if (!iAdapterFactory.getClass().equals(factory.getClass())) continue;
                return true;
            }
            ++i;
        }
        return false;
    }
}

