/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;

public abstract class ContextBasedView
extends ViewPart
implements IJBPart {
    private IContextActivation m_contextActivation;
    private String m_contextID;
    private ISelectionListener m_selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ContextBasedView.this.handleSelection(selection);
        }
    };

    public ContextBasedView(String contextID) {
        this.m_contextID = contextID;
    }

    protected ISelectionService getSelectionService() {
        return this.getSite().getWorkbenchWindow().getSelectionService();
    }

    protected void setStatusOfContext(boolean active) {
        IContextService cs = (IContextService)this.getSite().getWorkbenchWindow().getService(IContextService.class);
        if (cs != null) {
            if (active) {
                this.m_contextActivation = cs.activateContext(this.m_contextID);
            } else {
                cs.deactivateContext(this.m_contextActivation);
            }
        }
    }

    protected abstract void handleSelection(ISelection var1);

    public void createPartControl(Composite parent) {
        this.getSelectionService().addSelectionListener(this.m_selectionListener);
    }

    public void dispose() {
        this.getSelectionService().removeSelectionListener(this.m_selectionListener);
        super.dispose();
    }
}

