/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.highlighting;

import com.google.inject.Injector;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;

public class DotSubgrammarHighlighter {
    private String language;

    public DotSubgrammarHighlighter(String language) {
        this.language = language;
    }

    public void provideHightlightingFor(String text, final int startOffset, final IHighlightedPositionAcceptor hostGrammarAcceptor) {
        Injector injector = DotActivator.getInstance().getInjector(this.language);
        ISemanticHighlightingCalculator subgrammarCalculator = (ISemanticHighlightingCalculator)injector.getInstance(ISemanticHighlightingCalculator.class);
        XtextResource xtextResource = null;
        try {
            xtextResource = this.doGetResource(injector, (InputStream)new StringInputStream(text), URI.createURI((String)"dummy:/example.mydsl"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        subgrammarCalculator.provideHighlightingFor(xtextResource, new IHighlightedPositionAcceptor(){

            public void addPosition(int offset, int length, String ... id) {
                hostGrammarAcceptor.addPosition(startOffset + offset, length, id);
            }
        });
    }

    private XtextResource doGetResource(Injector injector, InputStream in, URI uri) throws Exception {
        XtextResourceSet rs = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        rs.setClasspathURIContext(this.getClass());
        XtextResource resource = (XtextResource)((IResourceFactory)injector.getInstance(IResourceFactory.class)).createResource(uri);
        rs.getResources().add((Object)resource);
        resource.load(in, null);
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
        } else {
            EcoreUtil.resolveAll((Resource)resource);
        }
        return resource;
    }
}

