/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.folding;

import com.google.inject.Injector;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.model.DocumentPartitioner;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;

public class DotFoldingRegionProvider
extends DefaultFoldingRegionProvider {
    private Injector injector;

    protected void computeObjectFolding(XtextResource xtextResource, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        EObject rootASTElement;
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (rootASTElement = parseResult.getRootASTElement()) != null) {
            TreeIterator allContents = rootASTElement.eAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (this.isHandled(eObject)) {
                    this.computeObjectFolding(eObject, foldingRegionAcceptor);
                }
                if (eObject instanceof Attribute) {
                    this.computeDotAttributeValueFolding((Attribute)eObject, foldingRegionAcceptor);
                }
                if (this.shouldProcessContent(eObject)) continue;
                allContents.prune();
            }
        }
    }

    private void computeDotAttributeValueFolding(Attribute attribute, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        if (attribute.getValue().getType() == ID.Type.HTML_STRING) {
            String htmlLabelValue = attribute.getValue().toValue();
            this.injector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
            IFoldingRegionProvider htmlLabelFoldingRegionProvider = (IFoldingRegionProvider)this.injector.getInstance(IFoldingRegionProvider.class);
            IXtextDocument xtextDocument = null;
            try {
                xtextDocument = this.getDocument(htmlLabelValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (xtextDocument != null) {
                Collection htmlLabelFoldingRegions = htmlLabelFoldingRegionProvider.getFoldingRegions(xtextDocument);
                for (FoldedPosition htmlFoldedPosition : htmlLabelFoldingRegions) {
                    int attributeValueStartOffset = this.getAttributeValueStartOffset(attribute);
                    foldingRegionAcceptor.accept(attributeValueStartOffset + htmlFoldedPosition.getOffset(), htmlFoldedPosition.getLength() - 1);
                }
            }
        }
    }

    private int getAttributeValueStartOffset(Attribute attribute) {
        ID attributeValue = attribute.getValue();
        List nodes = NodeModelUtils.findNodesForFeature((EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE);
        if (nodes.size() != 1) {
            System.err.println("Exact 1 node is expected for the attribute value: " + attributeValue + ", but got " + nodes.size());
            return 0;
        }
        INode node = (INode)nodes.get(0);
        int attributeValueStartOffset = node.getOffset();
        if (attributeValue.getType() == ID.Type.HTML_STRING || attributeValue.getType() == ID.Type.QUOTED_STRING) {
            ++attributeValueStartOffset;
        }
        return attributeValueStartOffset;
    }

    private IXtextDocument getDocument(String currentModelToParse) throws Exception {
        XtextResource xtextResource = this.doGetResource((InputStream)new StringInputStream(Strings.emptyIfNull((String)currentModelToParse)), URI.createURI((String)""));
        return this.getDocument(xtextResource, currentModelToParse);
    }

    private IXtextDocument getDocument(XtextResource xtextResource, String model) {
        XtextDocument document = this.get(XtextDocument.class);
        document.set(model);
        document.setInput(xtextResource);
        DocumentPartitioner partitioner = this.get(DocumentPartitioner.class);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }

    private <T> T get(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    private XtextResource doGetResource(InputStream in, URI uri) throws Exception {
        XtextResourceSet rs = this.get(XtextResourceSet.class);
        rs.setClasspathURIContext(((Object)((Object)this)).getClass());
        XtextResource resource = (XtextResource)this.getResourceFactory().createResource(uri);
        rs.getResources().add((Object)resource);
        resource.load(in, null);
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
        } else {
            EcoreUtil.resolveAll((Resource)resource);
        }
        return resource;
    }

    private IResourceFactory getResourceFactory() {
        return (IResourceFactory)this.injector.getInstance(IResourceFactory.class);
    }
}

