/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import javafx.geometry.Bounds;
import javafx.scene.text.Text;
import org.eclipse.gef.common.attributes.IAttributeCopier;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.point.Point;
import org.eclipse.gef.dot.internal.language.point.PointFactory;
import org.eclipse.gef.dot.internal.ui.Dot2ZestAttributesConverter;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.zest.fx.ZestProperties;

public class Zest2DotAttributesConverter
implements IAttributeCopier {
    private Dot2ZestAttributesConverter.Options options;

    public Dot2ZestAttributesConverter.Options options() {
        if (this.options == null) {
            this.options = new Dot2ZestAttributesConverter.Options();
        }
        return this.options;
    }

    protected void convertAttributes(Graph zest, Graph dot) {
    }

    protected void convertAttributes(Edge zest, Edge dot) {
        String zestTargetLabel;
        String zestSourceLabel;
        String zestExternalLabel;
        String zestLabel;
        String zestCssId = ZestProperties.getCssId((Edge)zest);
        if (zestCssId != null) {
            DotAttributes.setId((Edge)dot, (String)zestCssId);
        }
        if ((zestLabel = ZestProperties.getLabel((Edge)zest)) != null) {
            DotAttributes.setLabel((Edge)dot, (String)zestLabel);
        }
        if ((zestExternalLabel = ZestProperties.getExternalLabel((Edge)zest)) != null) {
            DotAttributes.setXlabel((Edge)dot, (String)zestExternalLabel);
        }
        if ((zestSourceLabel = ZestProperties.getSourceLabel((Edge)zest)) != null) {
            DotAttributes.setTaillabel((Edge)dot, (String)zestSourceLabel);
        }
        if ((zestTargetLabel = ZestProperties.getTargetLabel((Edge)zest)) != null) {
            DotAttributes.setHeadlabel((Edge)dot, (String)zestTargetLabel);
        }
    }

    protected void convertAttributes(Node zest, Node dot) {
        String zestExternalLabel;
        String zestLabel;
        String zestCssId = ZestProperties.getCssId((Node)zest);
        if (zestCssId != null) {
            DotAttributes.setId((Node)dot, (String)zestCssId);
        }
        if ((zestLabel = ZestProperties.getLabel((Node)zest)) != null) {
            DotAttributes.setLabel((Node)dot, (String)zestLabel);
        }
        if ((zestExternalLabel = ZestProperties.getExternalLabel((Node)zest)) != null) {
            DotAttributes.setXlabel((Node)dot, (String)zestExternalLabel);
        }
        org.eclipse.gef.geometry.planar.Point zestPosition = ZestProperties.getPosition((Node)zest);
        Dimension zestSize = ZestProperties.getSize((Node)zest);
        if (zestSize != null) {
            double dotWidth = zestSize.width / 72.0;
            double dotHeight = zestSize.height / 72.0;
            DotAttributes.setWidth((Node)dot, (String)Double.toString(dotWidth));
            DotAttributes.setHeight((Node)dot, (String)Double.toString(dotHeight));
            if (zestPosition != null && !this.options().ignorePositions) {
                Point dotPos = PointFactory.eINSTANCE.createPoint();
                dotPos.setX(zestPosition.x - zestSize.width / 2.0);
                dotPos.setY((double)(this.options().invertYAxis ? -1 : 1) * (zestPosition.y - zestSize.height / 2.0));
                dotPos.setInputOnly(Boolean.TRUE.equals(ZestProperties.getLayoutIrrelevant((Node)zest)));
                DotAttributes.setPosParsed((Node)dot, (Point)dotPos);
            }
        }
        org.eclipse.gef.geometry.planar.Point zestExternalLabelPosition = ZestProperties.getExternalLabelPosition((Node)zest);
        if (zestExternalLabel != null && zestExternalLabelPosition != null && !this.options().ignorePositions) {
            Point dotXlp = PointFactory.eINSTANCE.createPoint();
            Bounds labelSize = new Text(zestExternalLabel).getLayoutBounds();
            dotXlp.setX(zestExternalLabelPosition.x - labelSize.getWidth() / 2.0);
            dotXlp.setY((double)(this.options().invertYAxis ? -1 : 1) * (zestExternalLabelPosition.y - labelSize.getHeight() / 2.0));
            DotAttributes.setXlpParsed((Node)dot, (Point)dotXlp);
        }
    }

    public void copy(IAttributeStore source, IAttributeStore target) {
        if (source instanceof Node && target instanceof Node) {
            this.convertAttributes((Node)source, (Node)target);
        } else if (source instanceof Edge && target instanceof Edge) {
            this.convertAttributes((Edge)source, (Edge)target);
        } else if (source instanceof Graph && target instanceof Graph) {
            this.convertAttributes((Graph)source, (Graph)target);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

