/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Scene;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.dot.internal.DotExecutableUtils;
import org.eclipse.gef.dot.internal.DotExtractor;
import org.eclipse.gef.dot.internal.DotFileUtils;
import org.eclipse.gef.dot.internal.DotImport;
import org.eclipse.gef.dot.internal.ui.Dot2ZestGraphCopier;
import org.eclipse.gef.dot.internal.ui.DotGraphViewModule;
import org.eclipse.gef.dot.internal.ui.DotUiMessages;
import org.eclipse.gef.dot.internal.ui.GraphvizPreferencePage;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.mvc.fx.ui.actions.FitToViewportActionGroup;
import org.eclipse.gef.mvc.fx.ui.actions.ScrollActionGroup;
import org.eclipse.gef.mvc.fx.ui.actions.ZoomActionGroup;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;
import org.eclipse.gef.zest.fx.ui.ZestFxUiModule;
import org.eclipse.gef.zest.fx.ui.parts.ZestFxUiView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class DotGraphView
extends ZestFxUiView {
    public static final String STYLES_CSS_FILE = DotGraphView.class.getResource("styles.css").toExternalForm();
    private static final String EXTENSION = "dot";
    private static final String LOAD_DOT_FILE = DotUiMessages.DotGraphView_0;
    private static final String SYNC_IMPORT_DOT = DotUiMessages.DotGraphView_1;
    private static final String GRAPH_NONE = DotUiMessages.DotGraphView_2;
    private static final String GRAPH_RESOURCE = DotUiMessages.DotGraphView_3;
    private boolean listenToDotContent = false;
    private String currentDot = "digraph{}";
    private File currentFile = null;
    private Link resourceLabel = null;
    private Dot2ZestGraphCopier dot2ZestGraphCopier = new Dot2ZestGraphCopier();
    private IPropertyChangeListener preferenceChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("dotpath")) {
                DotGraphView.this.updateGraph(DotGraphView.this.currentFile);
            }
        }
    };
    private ZoomActionGroup zoomActionGroup;
    private FitToViewportActionGroup fitToViewportActionGroup;
    private ScrollActionGroup scrollActionGroup;

    public DotGraphView() {
        super(Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new DotGraphViewModule()}).with(new Module[]{new ZestFxUiModule()})}));
    }

    protected void activate() {
        super.activate();
        List importDot = new DotImport().importDot(this.currentDot);
        this.setGraph(importDot.isEmpty() ? null : (Graph)importDot.get(0));
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        GraphvizPreferencePage.dotUiPrefStore().addPropertyChangeListener(this.preferenceChangeListener);
    }

    protected boolean isNativeMode() {
        return GraphvizPreferencePage.isGraphvizConfigured();
    }

    public void dispose() {
        GraphvizPreferencePage.dotUiPrefStore().removePropertyChangeListener(this.preferenceChangeListener);
        this.currentDot = null;
        this.currentFile = null;
        if (this.fitToViewportActionGroup != null) {
            this.getContentViewer().unsetAdapter((Object)this.fitToViewportActionGroup);
            this.fitToViewportActionGroup.dispose();
            this.fitToViewportActionGroup = null;
        }
        if (this.zoomActionGroup != null) {
            this.getContentViewer().unsetAdapter((Object)this.zoomActionGroup);
            this.zoomActionGroup.dispose();
            this.zoomActionGroup = null;
        }
        if (this.scrollActionGroup != null) {
            this.getContentViewer().unsetAdapter((Object)this.scrollActionGroup);
            this.scrollActionGroup.dispose();
            this.scrollActionGroup = null;
        }
        this.getContentViewer().contentsProperty().clear();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Action updateToggleAction = new UpdateToggle().action(this);
        Action loadFileAction = new LoadFile().action(this);
        this.add(updateToggleAction, "IMG_ELCL_SYNCED");
        this.add(loadFileAction, "IMG_OBJ_FILE");
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager mgr = actionBars.getToolBarManager();
        mgr.add((IContributionItem)new Separator());
        this.zoomActionGroup = new ZoomActionGroup(new IAction[0]);
        this.getContentViewer().setAdapter((Object)this.zoomActionGroup);
        this.fitToViewportActionGroup = new FitToViewportActionGroup();
        this.getContentViewer().setAdapter((Object)this.fitToViewportActionGroup);
        this.scrollActionGroup = new ScrollActionGroup();
        this.getContentViewer().setAdapter((Object)this.scrollActionGroup);
        this.zoomActionGroup.fillActionBars(actionBars);
        mgr.add((IContributionItem)new Separator());
        this.fitToViewportActionGroup.fillActionBars(actionBars);
        mgr.add((IContributionItem)new Separator());
        this.scrollActionGroup.fillActionBars(actionBars);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.initResourceLabel(parent, loadFileAction, updateToggleAction);
        this.getCanvas().setLayoutData((Object)new GridData(1808));
        Scene scene = this.getContentViewer().getCanvas().getScene();
        scene.getStylesheets().add((Object)STYLES_CSS_FILE);
    }

    private void initResourceLabel(Composite parent, final Action loadAction, final Action toggleAction) {
        this.resourceLabel = new Link(parent, 64);
        this.resourceLabel.setText(GRAPH_NONE);
        this.resourceLabel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.processEvent(loadAction, toggleAction, GRAPH_NONE, e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.processEvent(loadAction, toggleAction, GRAPH_NONE, e);
            }

            private void processEvent(Action loadFileAction, Action toggleAction2, String label, SelectionEvent e) {
                if (label.replaceAll("<a>", "").startsWith(e.text)) {
                    loadFileAction.run();
                } else {
                    toggleAction2.setChecked(!toggleAction2.isChecked());
                    toggleAction2.run();
                }
            }
        });
        this.resourceLabel.setLayoutData((Object)new GridData(768));
    }

    private void add(Action action, String imageName) {
        action.setId(action.getText());
        if (imageName != null) {
            action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageName));
        }
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)action);
    }

    private void setGraphAsync(final String dot, final File file) {
        this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!dot.trim().isEmpty()) {
                    try {
                        List importDot = new DotImport().importDot(dot);
                        DotGraphView.this.setGraph(importDot.isEmpty() ? null : (Graph)importDot.get(0));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String message = String.format("Could not import DOT: %s, DOT: %s", e.getMessage(), dot);
                        DotActivator.getInstance().getLog().log((IStatus)new Status(4, DotActivator.getInstance().getBundle().getSymbolicName(), message));
                        MultiStatus status = this.createMultiStatus(e.getLocalizedMessage(), e);
                        ErrorDialog.openError((Shell)DotGraphView.this.getViewSite().getShell(), (String)"Error", (String)"Could not import DOT", (IStatus)status);
                        return;
                    }
                    DotGraphView.this.resourceLabel.setText(String.valueOf(String.format(GRAPH_RESOURCE, file.getName())) + (DotGraphView.this.isNativeMode() ? " [native]" : " [emulated]"));
                    DotGraphView.this.resourceLabel.setToolTipText(file.getAbsolutePath());
                }
            }

            private MultiStatus createMultiStatus(String localizedMessage, Throwable t) {
                ArrayList<Status> childStatuses = new ArrayList<Status>();
                String pluginId = DotActivator.getInstance().getBundle().getSymbolicName();
                Status status = new Status(4, pluginId, dot);
                childStatuses.add(status);
                MultiStatus ms = new MultiStatus(pluginId, 4, (IStatus[])childStatuses.toArray(new Status[0]), t.toString(), t);
                return ms;
            }
        });
    }

    public void setGraph(Graph graph) {
        boolean isNativeMode = this.isNativeMode();
        this.dot2ZestGraphCopier.getAttributeCopier().options().emulateLayout = !isNativeMode;
        this.dot2ZestGraphCopier.getAttributeCopier().options().invertYAxis = false;
        super.setGraph(this.dot2ZestGraphCopier.copy(graph));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                InfiniteCanvas canvas = ((InfiniteCanvasViewer)DotGraphView.this.getContentViewer()).getCanvas();
                canvas.setHorizontalScrollOffset(canvas.getHorizontalScrollOffset() - canvas.getContentBounds().getMinX());
                canvas.setVerticalScrollOffset(canvas.getVerticalScrollOffset() - canvas.getContentBounds().getMinY());
            }
        });
    }

    private boolean toggle(Action action, boolean input) {
        action.setChecked(!action.isChecked());
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = mgr.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction() == action) {
                action.setChecked(!action.isChecked());
                return !input;
            }
            ++n2;
        }
        return input;
    }

    private boolean updateGraph(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        this.currentFile = file;
        boolean isEmbeddedDotFile = !this.currentFile.getName().endsWith(".dot");
        DotExtractor dotExtractor = null;
        if (isEmbeddedDotFile) {
            dotExtractor = new DotExtractor(this.currentFile);
            this.currentDot = dotExtractor.getDotString();
        } else {
            this.currentDot = DotFileUtils.read((File)this.currentFile);
        }
        if (this.isNativeMode()) {
            String[] result;
            if (isEmbeddedDotFile) {
                File tempDotFile = dotExtractor.getDotTempFile();
                if (tempDotFile == null) {
                    return false;
                }
                result = DotExecutableUtils.executeDot((File)new File(GraphvizPreferencePage.getDotExecutablePath()), (boolean)true, (File)tempDotFile, null, null);
                tempDotFile.delete();
            } else {
                result = DotExecutableUtils.executeDot((File)new File(GraphvizPreferencePage.getDotExecutablePath()), (boolean)true, (File)file, null, null);
            }
            this.currentDot = result[0];
        }
        this.setGraphAsync(this.currentDot, this.currentFile);
        return true;
    }

    private IWorkspaceRunnable updateGraphRunnable(final File f) {
        if (!this.listenToDotContent && !f.getAbsolutePath().toString().endsWith(EXTENSION)) {
            return null;
        }
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (DotGraphView.this.updateGraph(f)) {
                    DotGraphView.this.currentFile = f;
                }
            }
        };
        return workspaceRunnable;
    }

    private class LoadFile {
        private String lastSelection = null;

        private LoadFile() {
        }

        Action action(final DotGraphView view) {
            return new Action(LOAD_DOT_FILE){

                public void run() {
                    FileDialog dialog = new FileDialog(view.getViewSite().getShell(), 4096);
                    dialog.setFileName(LoadFile.this.lastSelection);
                    String dotFileNamePattern = "*.dot";
                    String embeddedDotFileNamePattern = "*.*";
                    dialog.setFilterExtensions(new String[]{dotFileNamePattern, embeddedDotFileNamePattern});
                    dialog.setFilterNames(new String[]{String.format("DOT file (%s)", dotFileNamePattern), String.format("Embedded DOT Graph (%s)", embeddedDotFileNamePattern)});
                    String selection = dialog.open();
                    if (selection != null) {
                        LoadFile.this.lastSelection = selection;
                        view.updateGraph(new File(selection));
                    }
                }
            };
        }
    }

    private class UpdateToggle {
        private IResourceChangeListener resourceChangeListener;
        private IResourceDeltaVisitor resourceVisitor;
        protected ISelectionListener selectionChangeListener = null;

        private UpdateToggle() {
        }

        Action action(final DotGraphView view) {
            Action toggleUpdateModeAction = new Action(SYNC_IMPORT_DOT, 2){

                public void run() {
                    DotGraphView.this.listenToDotContent = DotGraphView.this.toggle(this, DotGraphView.this.listenToDotContent);
                    this.toggleResourceListener();
                }

                private void toggleResourceListener() {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    ISelectionService service = DotGraphView.this.getSite().getWorkbenchWindow().getSelectionService();
                    if (view.listenToDotContent) {
                        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        UpdateToggle.this.checkActiveEditorAndUpdateGraph((IWorkbenchPart)activeEditor);
                        workspace.addResourceChangeListener(UpdateToggle.this.resourceChangeListener, 17);
                        service.addSelectionListener(UpdateToggle.this.selectionChangeListener);
                    } else {
                        workspace.removeResourceChangeListener(UpdateToggle.this.resourceChangeListener);
                        service.removeSelectionListener(UpdateToggle.this.selectionChangeListener);
                    }
                }
            };
            this.selectionChangeListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    UpdateToggle.this.checkActiveEditorAndUpdateGraph(part);
                }
            };
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    if (event.getType() != 16 && event.getType() != 1) {
                        return;
                    }
                    IResourceDelta rootDelta = event.getDelta();
                    try {
                        rootDelta.accept(UpdateToggle.this.resourceVisitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.resourceVisitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && ((IFile)resource).getName().endsWith(DotGraphView.EXTENSION)) {
                        try {
                            IFile f = (IFile)resource;
                            IWorkspaceRunnable workspaceRunnable = view.updateGraphRunnable(DotFileUtils.resolve((URL)f.getLocationURI().toURL()));
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            if (!workspace.isTreeLocked()) {
                                workspace.run(workspaceRunnable, null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
            };
            return toggleUpdateModeAction;
        }

        private void checkActiveEditorAndUpdateGraph(IWorkbenchPart part) {
            XtextEditor editor;
            if (part instanceof XtextEditor && "org.eclipse.gef.dot.internal.language.Dot".equals((editor = (XtextEditor)part).getLanguageName()) && editor.getEditorInput() instanceof FileEditorInput) {
                try {
                    File resolvedFile = DotFileUtils.resolve((URL)((FileEditorInput)editor.getEditorInput()).getFile().getLocationURI().toURL());
                    if (!resolvedFile.equals(DotGraphView.this.currentFile)) {
                        DotGraphView.this.updateGraph(resolvedFile);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

