/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.internal.common.revision.CDOElementProxyImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDOListImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.ecore.EClassifier;

public class CDOListWithElementProxiesImpl
extends CDOListImpl {
    public static final CDOListFactory FACTORY = new CDOListFactory(){

        public CDOList createList(int initialCapacity, int size, int initialChunk) {
            return new CDOListWithElementProxiesImpl(initialCapacity, size, initialChunk);
        }
    };
    private static final long serialVersionUID = 1L;

    public CDOListWithElementProxiesImpl(int initialCapacity, int size, int initialChunk) {
        super(initialCapacity, initialChunk);
        int j = initialChunk;
        while (j < size) {
            this.add(new CDOElementProxyImpl(j));
            ++j;
        }
    }

    public Object get(int index, boolean resolve) {
        if (resolve) {
            return this.get(index);
        }
        Object element = super.get(index);
        return element instanceof CDOElementProxy ? UNINITIALIZED : element;
    }

    protected void handleAdjustReference(int index, Object element) {
        if (element instanceof CDOElementProxy) {
            ((CDOElementProxyImpl)element).setIndex(index);
        }
    }

    public InternalCDOList clone(EClassifier classifier) {
        CDOType type = CDOModelUtil.getType(classifier);
        int size = this.size();
        CDOListWithElementProxiesImpl list = new CDOListWithElementProxiesImpl(size, 0, 0);
        list.setUseEquals(this.useEquals());
        int j = 0;
        while (j < size) {
            Object value = this.get(j);
            if (value instanceof CDOElementProxy) {
                list.add(j, new CDOElementProxyImpl(((CDOElementProxy)value).getIndex()));
            } else {
                list.add(j, type.copyValue(value));
            }
            ++j;
        }
        return list;
    }
}

