/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchProjectTracker;
import org.eclipse.egit.ui.internal.branch.CleanupUncomittedChangesDialog;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesDialog;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class BranchOperationUI {
    private final Repository repository;
    private String target;
    private final boolean showQuestionsBeforeCheckout;

    public static BranchOperationUI checkout(Repository repository, String target) {
        return new BranchOperationUI(repository, target, true);
    }

    public static boolean checkoutWillShowQuestionDialog(String refName) {
        return BranchOperationUI.shouldShowCheckoutRemoteTrackingDialog(refName);
    }

    private BranchOperationUI(Repository repository, String target, boolean showQuestionsBeforeCheckout) {
        this.repository = repository;
        this.target = target;
        this.showQuestionsBeforeCheckout = showQuestionsBeforeCheckout;
    }

    private String confirmTarget(IProgressMonitor monitor) {
        if (this.target != null) {
            if (!this.repository.getRepositoryState().canCheckout()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)BranchOperationUI.this.getShell(), (String)UIText.BranchAction_cannotCheckout, (String)NLS.bind((String)UIText.BranchAction_repositoryState, (Object)BranchOperationUI.this.repository.getRepositoryState().getDescription()));
                    }
                });
                return null;
            }
            if (LaunchFinder.shouldCancelBecauseOfRunningLaunches(this.repository, monitor)) {
                return null;
            }
            this.askForTargetIfNecessary();
        }
        return this.target;
    }

    private void doCheckout(BranchOperation bop, boolean restore, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(restore ? 10 : 1));
        if (!restore) {
            bop.execute((IProgressMonitor)progress.newChild(1));
        } else {
            final BranchProjectTracker tracker = new BranchProjectTracker(this.repository);
            IMemento snapshot = tracker.snapshot();
            bop.execute((IProgressMonitor)progress.newChild(7));
            tracker.save(snapshot);
            IWorkspaceRunnable action = new IWorkspaceRunnable(){

                public void run(IProgressMonitor innerMonitor) throws CoreException {
                    tracker.restore(innerMonitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(action, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)progress.newChild(3));
        }
    }

    public void start() {
        this.target = this.confirmTarget((IProgressMonitor)new NullProgressMonitor());
        if (this.target == null) {
            return;
        }
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        String jobname = NLS.bind((String)UIText.BranchAction_checkingOut, (Object)repoName, (Object)this.target);
        boolean restore = Activator.getDefault().getPreferenceStore().getBoolean("restore_projects_on_checkout");
        final CheckoutJob job = new CheckoutJob(jobname, restore);
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                BranchOperationUI.this.show(job.getCheckoutResult());
            }
        });
        job.schedule();
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.target = this.confirmTarget((IProgressMonitor)progress.newChild(20));
        if (this.target == null) {
            return;
        }
        boolean restore = Activator.getDefault().getPreferenceStore().getBoolean("restore_projects_on_checkout");
        BranchOperation bop = new BranchOperation(this.repository, this.target, !restore);
        this.doCheckout(bop, restore, (IProgressMonitor)progress.newChild(80));
        this.show(bop.getResult());
    }

    private void askForTargetIfNecessary() {
        if (this.target != null && this.showQuestionsBeforeCheckout && BranchOperationUI.shouldShowCheckoutRemoteTrackingDialog(this.target)) {
            this.target = this.getTargetWithCheckoutRemoteTrackingDialog();
        }
    }

    private static boolean shouldShowCheckoutRemoteTrackingDialog(String refName) {
        boolean isRemoteTrackingBranch;
        boolean bl = isRemoteTrackingBranch = refName != null && refName.startsWith("refs/remotes/");
        if (isRemoteTrackingBranch) {
            boolean showDetachedHeadWarning = Activator.getDefault().getPreferenceStore().getBoolean("show_detached_head_warning");
            return showDetachedHeadWarning;
        }
        return false;
    }

    private String getTargetWithCheckoutRemoteTrackingDialog() {
        final String[] dialogResult = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialogResult[0] = BranchOperationUI.this.getTargetWithCheckoutRemoteTrackingDialogInUI();
            }
        });
        return dialogResult[0];
    }

    private String getTargetWithCheckoutRemoteTrackingDialogInUI() {
        String[] buttons = new String[]{UIText.BranchOperationUI_CheckoutRemoteTrackingAsLocal, UIText.BranchOperationUI_CheckoutRemoteTrackingCommit, IDialogConstants.CANCEL_LABEL};
        MessageDialog questionDialog = new MessageDialog(this.getShell(), UIText.BranchOperationUI_CheckoutRemoteTrackingTitle, null, UIText.BranchOperationUI_CheckoutRemoteTrackingQuestion, 3, buttons, 0);
        int result = questionDialog.open();
        if (result == 0) {
            CreateBranchWizard wizard = new CreateBranchWizard(this.repository, this.target);
            WizardDialog createBranchDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            createBranchDialog.open();
            return null;
        }
        if (result == 1) {
            return this.target;
        }
        return null;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    private void show(final @NonNull CheckoutResult result) {
        if (result.getStatus() == CheckoutResult.Status.CONFLICTS) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    CleanupUncomittedChangesDialog cleanupUncomittedChangesDialog = new CleanupUncomittedChangesDialog(shell, UIText.BranchResultDialog_CheckoutConflictsTitle, NLS.bind((String)UIText.BranchResultDialog_CheckoutConflictsMessage, (Object)Repository.shortenRefName((String)BranchOperationUI.this.target)), BranchOperationUI.this.repository, result.getConflictList());
                    cleanupUncomittedChangesDialog.open();
                    if (cleanupUncomittedChangesDialog.shouldContinue()) {
                        BranchOperationUI op = new BranchOperationUI(BranchOperationUI.this.repository, BranchOperationUI.this.target, false, null);
                        op.start();
                    }
                }
            });
        } else if (result.getStatus() == CheckoutResult.Status.NONDELETED) {
            boolean show = false;
            List pathList = result.getUndeletedList();
            for (String path : pathList) {
                if (!new File(this.repository.getWorkTree(), path).exists()) continue;
                show = true;
                break;
            }
            if (!show) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new NonDeletedFilesDialog(shell, BranchOperationUI.this.repository, result.getUndeletedList()).open();
                }
            });
        } else if (result.getStatus() == CheckoutResult.Status.OK && RepositoryUtil.isDetachedHead((Repository)this.repository)) {
            this.showDetachedHeadWarning();
        }
    }

    private void showDetachedHeadWarning() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                if (store.getBoolean("show_detached_head_warning")) {
                    String toggleMessage = UIText.BranchResultDialog_DetachedHeadWarningDontShowAgain;
                    MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIText.BranchOperationUI_DetachedHeadTitle, (String)UIText.BranchOperationUI_DetachedHeadMessage, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)"show_detached_head_warning");
                }
            }
        });
    }

    /* synthetic */ BranchOperationUI(Repository repository, String string, boolean bl, BranchOperationUI branchOperationUI) {
        this(repository, string, bl);
    }

    private class CheckoutJob
    extends Job {
        private BranchOperation bop;
        private final boolean restore;

        public CheckoutJob(String jobName, boolean restore) {
            super(jobName);
            this.restore = restore;
        }

        public IStatus run(IProgressMonitor monitor) {
            this.bop = new BranchOperation(BranchOperationUI.this.repository, BranchOperationUI.this.target, !this.restore);
            try {
                try {
                    BranchOperationUI.this.doCheckout(this.bop, this.restore, monitor);
                }
                catch (CoreException e) {
                    switch (this.bop.getResult().getStatus()) {
                        case CONFLICTS: 
                        case NONDELETED: {
                            break;
                        }
                        default: {
                            IStatus iStatus = Activator.createErrorStatus(UIText.BranchAction_branchFailed, e);
                            GitLightweightDecorator.refresh();
                            monitor.done();
                            return iStatus;
                        }
                    }
                    GitLightweightDecorator.refresh();
                    monitor.done();
                }
            }
            finally {
                GitLightweightDecorator.refresh();
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            if (JobFamilies.CHECKOUT.equals(family)) {
                return true;
            }
            return super.belongsTo(family);
        }

        @NonNull
        public CheckoutResult getCheckoutResult() {
            return this.bop.getResult();
        }
    }
}

