/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.osgi.util.NLS;

public class ValidationUtils {
    public static IInputValidator getRefNameInputValidator(final Repository repo, final String refPrefix, final boolean errorOnEmptyName) {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    if (errorOnEmptyName) {
                        return UIText.ValidationUtils_PleaseEnterNameMessage;
                    }
                    return null;
                }
                String testFor = String.valueOf(refPrefix) + newText;
                if (!Repository.isValidRefName((String)testFor)) {
                    return NLS.bind((String)UIText.ValidationUtils_InvalidRefNameMessage, (Object)testFor);
                }
                try {
                    if (repo.resolve(testFor) != null) {
                        return NLS.bind((String)UIText.ValidationUtils_RefAlreadyExistsMessage, (Object)testFor);
                    }
                    RefDatabase refDatabase = repo.getRefDatabase();
                    Collection conflictingNames = refDatabase.getConflictingNames(testFor);
                    if (!conflictingNames.isEmpty()) {
                        ArrayList names = new ArrayList(conflictingNames);
                        Collections.sort(names);
                        String joined = StringUtils.join(names, (String)", ");
                        return NLS.bind((String)UIText.ValidationUtils_RefNameConflictsWithExistingMessage, (Object)joined);
                    }
                }
                catch (IOException e) {
                    Activator.logError(NLS.bind((String)UIText.ValidationUtils_CanNotResolveRefMessage, (Object)testFor), e);
                    return e.getMessage();
                }
                catch (RevisionSyntaxException e) {
                    String m = MessageFormat.format(UIText.ValidationUtils_InvalidRevision, testFor);
                    Activator.logError(m, e);
                    return m;
                }
                return null;
            }
        };
    }
}

