/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IUpdate;

public final class ActionUtils {
    private ActionUtils() {
    }

    public static IAction createGlobalAction(ActionFactory factory, final Runnable action) {
        final String text = factory.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getText();
        Action result = new Action(){

            public String getText() {
                return text;
            }

            public void run() {
                action.run();
            }
        };
        result.setActionDefinitionId(factory.getCommandId());
        result.setId(factory.getId());
        return result;
    }

    public static IAction createGlobalAction(ActionFactory factory, final Runnable action, final BooleanSupplier enabled) {
        final String text = factory.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getText();
        Action result = new Action(){

            public String getText() {
                return text;
            }

            public void run() {
                action.run();
            }

            public boolean isEnabled() {
                return enabled.getAsBoolean();
            }
        };
        result.setActionDefinitionId(factory.getCommandId());
        result.setId(factory.getId());
        return result;
    }

    public static void setGlobalActions(Control control, final Collection<? extends IAction> actions, final IHandlerService service) {
        final ArrayList handlerActivations = new ArrayList();
        control.addDisposeListener(event -> {
            if (!handlerActivations.isEmpty()) {
                service.deactivateHandlers(handlerActivations);
                handlerActivations.clear();
            }
        });
        final ActiveShellExpression expression = new ActiveShellExpression(control.getShell());
        control.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (!handlerActivations.isEmpty()) {
                    service.deactivateHandlers(handlerActivations);
                    handlerActivations.clear();
                }
            }

            public void focusGained(FocusEvent e) {
                if (!handlerActivations.isEmpty()) {
                    return;
                }
                for (IAction action : actions) {
                    handlerActivations.add(service.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action), (Expression)expression, false));
                    if (!(action instanceof IUpdate)) continue;
                    ((IUpdate)action).update();
                }
            }
        });
    }

    public static void setGlobalActions(Control control, IHandlerService service, IAction ... actions) {
        ActionUtils.setGlobalActions(control, Arrays.asList(actions), service);
    }

    public static void setGlobalActions(Control control, Collection<? extends IAction> actions) {
        ActionUtils.setGlobalActions(control, actions, CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), IHandlerService.class));
    }

    public static void setGlobalActions(Control control, IAction ... actions) {
        ActionUtils.setGlobalActions(control, Arrays.asList(actions));
    }
}

