/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.process;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.SetReviewCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.ReviewInput;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ChangeMessageInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.swt.widgets.Shell;

public class ReplyProcess {
    public static final String REPLY_ALL_BUTTONS = Messages.ReplyProcess_AllButtons;
    private ChangeInfo changeInfo = null;
    private GerritClient gerritClient = null;

    public void handleReplyDialog(Shell shell, ChangeInfo changeInfo, GerritClient gerritClient, RevisionInfo selectedRevision, ChangeMessageInfo messageInfo) {
        UIUtils.replyToChange(shell, selectedRevision, null, gerritClient, false, messageInfo);
        CompletableFuture.runAsync(() -> QueryHelpers.loadBasicInformation(gerritClient, changeInfo, false)).thenRun(() -> changeInfo.setUserSelectedRevision(selectedRevision));
    }

    public void handleReplyVotes(ChangeInfo changeInfo, Map<String, Integer> allowedButton, GerritClient gerritClient) {
        this.gerritClient = gerritClient;
        this.changeInfo = changeInfo;
        RevisionInfo selectedRevision = changeInfo.getRevision();
        ReviewInput reviewInput = new ReviewInput();
        reviewInput.setDrafts("PUBLISH");
        HashMap<String, Integer> obj = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : allowedButton.entrySet()) {
            obj.put(entry.getKey(), entry.getValue());
        }
        reviewInput.setLabels(obj);
        this.postReply(reviewInput, selectedRevision);
    }

    private void postReply(ReviewInput reviewInput, RevisionInfo selectedRevision) {
        if (this.changeInfo != null && this.gerritClient != null) {
            SetReviewCommand reviewToEmit = this.gerritClient.setReview(this.changeInfo.getId(), selectedRevision.getId());
            reviewToEmit.setCommandInput((Object)reviewInput);
            try {
                reviewToEmit.call();
                CompletableFuture.runAsync(() -> QueryHelpers.loadBasicInformation(this.gerritClient, this.changeInfo, false)).thenRun(() -> this.changeInfo.setUserSelectedRevision(selectedRevision));
            }
            catch (EGerritException e1) {
                EGerritCorePlugin.logError((String)(String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
            }
        }
    }
}

