/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.ui.viewsupport.StorageLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RubyLabelProvider
extends LabelProvider {
    public static final String PACKAGE_SEPARATOR = "::";
    public static final String SEPARATOR = " - ";
    public static final String FOLDER_SEPARATOR = "/";
    public static final String METHOD_SEPARATOR = "#";
    private final StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();

    public Image getImage(Object element) {
        if (element instanceof IStorage) {
            return this.fStorageLabelProvider.getImage(element);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ISourceModule) {
            StringBuffer sb = new StringBuffer();
            RubyLabelProvider.appendSourceModule((ISourceModule)element, sb);
            return sb.toString();
        }
        if (element instanceof IType) {
            StringBuffer sb = new StringBuffer();
            RubyLabelProvider.appendQualifiedType((IType)element, sb);
            return sb.toString();
        }
        if (element instanceof IMethod) {
            StringBuffer sb = new StringBuffer();
            RubyLabelProvider.appendQualifiedMethod((IMethod)element, sb);
            return sb.toString();
        }
        return super.getText(element);
    }

    public void dispose() {
        this.fStorageLabelProvider.dispose();
    }

    public static void appendQualifiedMethod(IMethod method, StringBuffer sb) {
        IModelElement parent = method.getParent();
        IType type = parent instanceof IType ? (IType)parent : null;
        if (type != null) {
            String[] parameters;
            ISourceModule module = RubyLabelProvider.appendType(type, sb);
            sb.append(METHOD_SEPARATOR);
            sb.append(method.getElementName());
            try {
                parameters = method.getParameterNames();
            }
            catch (ModelException e) {
                parameters = null;
            }
            if (parameters != null) {
                sb.append('(');
                int i = 0;
                while (i < parameters.length) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(parameters[i]);
                    ++i;
                }
                sb.append(')');
            }
            if (module != null) {
                sb.append(SEPARATOR);
                RubyLabelProvider.appendSourceModule(module, sb);
            }
        }
    }

    public static void appendQualifiedType(IType type, StringBuffer sb) {
        ISourceModule parentModule;
        sb.append(type.getElementName());
        IModelElement parent = type.getParent();
        if (parent instanceof IType) {
            sb.append(SEPARATOR);
            parentModule = RubyLabelProvider.appendType((IType)parent, sb);
        } else {
            parentModule = parent instanceof ISourceModule ? (ISourceModule)parent : null;
        }
        if (parentModule != null) {
            sb.append(SEPARATOR);
            RubyLabelProvider.appendSourceModule(parentModule, sb);
        }
    }

    private static ISourceModule appendType(IType type, StringBuffer sb) {
        IModelElement parent = type.getParent();
        if (parent instanceof IType) {
            ISourceModule module = RubyLabelProvider.appendType((IType)parent, sb);
            sb.append(PACKAGE_SEPARATOR);
            sb.append(type.getElementName());
            return module;
        }
        sb.append(type.getElementName());
        if (parent instanceof ISourceModule) {
            return (ISourceModule)parent;
        }
        return null;
    }

    public static void appendSourceModule(ISourceModule module, StringBuffer sb) {
        IModelElement parent = module.getParent();
        IProjectFragment fragment = parent instanceof IScriptFolder ? RubyLabelProvider.appendScriptFolder((IScriptFolder)parent, sb) : null;
        sb.append(module.getElementName());
        if (fragment != null && !fragment.isArchive()) {
            if (fragment.getPath().toString().startsWith("#special#builtin#")) {
                sb.append(' ');
                sb.append("(builtins)");
            } else if (fragment.isExternal()) {
                sb.append(SEPARATOR);
                sb.append(EnvironmentPathUtils.getLocalPath((IPath)fragment.getPath()).toPortableString());
            }
        }
    }

    private static IProjectFragment appendScriptFolder(IScriptFolder folder, StringBuffer sb) {
        IModelElement parent = folder.getParent();
        Object fragment = parent instanceof IScriptFolder ? RubyLabelProvider.appendScriptFolder((IScriptFolder)parent, sb) : (parent instanceof IProjectFragment ? (IProjectFragment)parent : null);
        if (!folder.isRootFolder()) {
            sb.append(folder.getElementName());
            sb.append(FOLDER_SEPARATOR);
        }
        return fragment;
    }
}

