/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.debug.application;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.internal.debug.application.BuildOptionsParser;
import org.eclipse.cdt.internal.debug.application.CompilerOptionParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugExecutable {
    private static final String GCC_BUILTIN_PROVIDER_ID = "org.eclipse.cdt.managedbuilder.core.GCCBuiltinSpecsDetector";
    private static final String GCC_COMPILE_OPTIONS_PROVIDER_ID = "org.eclipse.cdt.debug.application.DwarfLanguageSettingsProvider";
    private static final String GCC_BUILD_OPTIONS_PROVIDER_ID = "org.eclipse.cdt.managedbuilder.core.GCCBuildCommandParser";
    private static final String STANDALONE_QUALIFIER = "org.eclipse.cdt.debug.application";
    private static final String LAST_LAUNCH = "lastLaunch";

    public static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static ILaunchConfiguration importAndCreateLaunchConfig(IProgressMonitor monitor, String executable, String buildLog, String arguments, boolean startup) throws CoreException, InterruptedException {
        IResource[] resources;
        Object executables;
        ILaunchConfiguration config = null;
        File executableFile = new File(executable);
        String defaultProjectName = "Executables";
        ICProject cProject = CoreModel.getDefault().getCModel().getCProject(defaultProjectName);
        if (startup && cProject.exists() && executableFile.exists()) {
            ILaunchConfiguration[] lconfigs;
            monitor.subTask(Messages.RemoveOldExecutable);
            IProject proj = cProject.getProject();
            Collection elist = ExecutablesManager.getExecutablesManager().getExecutablesForProject(proj);
            executables = new Executable[elist.size()];
            elist.toArray((T[])executables);
            IStatus rc = ExecutablesManager.getExecutablesManager().removeExecutables((Executable[])executables, (IProgressMonitor)new NullProgressMonitor());
            IResource[] iResourceArray = resources = proj.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                resource.delete(5, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
            monitor.worked(1);
            String memento = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(new QualifiedName(STANDALONE_QUALIFIER, LAST_LAUNCH));
            if (memento != null) {
                ILaunchConfiguration lastConfiguration = DebugExecutable.getLaunchManager().getLaunchConfiguration(memento);
                try {
                    lastConfiguration.getType();
                    if (lastConfiguration.exists()) {
                        lastConfiguration.delete();
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ILaunchConfiguration[] iLaunchConfigurationArray = lconfigs = DebugExecutable.getLaunchManager().getLaunchConfigurations();
            int n3 = lconfigs.length;
            int n4 = 0;
            while (n4 < n3) {
                ILaunchConfiguration lconfig = iLaunchConfigurationArray[n4];
                if (lconfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").equals(proj.getName())) {
                    lconfig.delete();
                }
                ++n4;
            }
            proj.delete(true, (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
        }
        final String[] fileNames = new String[]{executable};
        Job importJob = new Job(Messages.ExecutablesView_ImportExecutables){

            public IStatus run(IProgressMonitor monitor) {
                ExecutablesManager.getExecutablesManager().importExecutables(fileNames, monitor);
                return Status.OK_STATUS;
            }
        };
        monitor.subTask(Messages.ImportExecutable);
        importJob.schedule();
        importJob.join();
        monitor.worked(3);
        if (importJob.getResult() == Status.OK_STATUS) {
            IWorkbenchPage activePage;
            IWorkbenchWindow workbenchWindow;
            IWorkbench workbench;
            executables = ExecutablesManager.getExecutablesManager().getExecutables();
            resources = executables.iterator();
            while (resources.hasNext()) {
                Executable exec = (Executable)resources.next();
                if (!exec.getName().contains(executableFile.getName())) continue;
                cProject = CoreModel.getDefault().getCModel().getCProject(exec.getProject().getName());
            }
            if (cProject.exists()) {
                File f;
                File buildLogFile = null;
                IProject project = cProject.getProject();
                ICProjectDescriptionManager projDescManager = CCorePlugin.getDefault().getProjectDescriptionManager();
                ICProjectDescription projectDescription = projDescManager.getProjectDescription(project, 4);
                monitor.subTask(Messages.SetLanguageProviders);
                ICConfigurationDescription ccd = projectDescription.getActiveConfiguration();
                String[] langProviderIds = ((ILanguageSettingsProvidersKeeper)ccd).getDefaultLanguageSettingsProvidersIds();
                boolean found = false;
                int i = 0;
                while (i < langProviderIds.length) {
                    if (langProviderIds[i].equals(GCC_BUILTIN_PROVIDER_ID)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    langProviderIds = Arrays.copyOf(langProviderIds, langProviderIds.length + 1);
                    langProviderIds[langProviderIds.length - 1] = GCC_BUILTIN_PROVIDER_ID;
                }
                found = false;
                i = 0;
                while (i < langProviderIds.length) {
                    if (langProviderIds[i].equals(GCC_COMPILE_OPTIONS_PROVIDER_ID)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    langProviderIds = Arrays.copyOf(langProviderIds, langProviderIds.length + 1);
                    langProviderIds[langProviderIds.length - 1] = GCC_COMPILE_OPTIONS_PROVIDER_ID;
                }
                if (buildLog != null && (f = new File(buildLog)).exists()) {
                    buildLogFile = f;
                    found = false;
                    int i2 = 0;
                    while (i2 < langProviderIds.length) {
                        if (langProviderIds[i2].equals(GCC_BUILD_OPTIONS_PROVIDER_ID)) {
                            found = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!found) {
                        langProviderIds = Arrays.copyOf(langProviderIds, langProviderIds.length + 1);
                        langProviderIds[langProviderIds.length - 1] = GCC_BUILD_OPTIONS_PROVIDER_ID;
                    }
                }
                List providers = LanguageSettingsManager.createLanguageSettingsProviders((String[])langProviderIds);
                ((ILanguageSettingsProvidersKeeper)ccd).setLanguageSettingProviders(providers);
                monitor.worked(1);
                projDescManager.setProjectDescription(project, projectDescription);
                ICProjectDescription projDescReadOnly = projDescManager.getProjectDescription(project, false);
                LanguageSettingsManager.serializeLanguageSettings((ICProjectDescription)projDescReadOnly);
                monitor.worked(1);
                if (!"".equals(executable)) {
                    project.getWorkspace().run((IWorkspaceRunnable)new CompilerOptionParser(project, executable), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
                }
                if (buildLogFile != null) {
                    project.getWorkspace().run((IWorkspaceRunnable)new BuildOptionsParser(project, buildLogFile), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            if ((workbench = PlatformUI.getWorkbench()) != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null) {
                activePage.closeAllEditors(false);
            }
            config = DebugExecutable.createConfiguration(executable, arguments, buildLog, true);
            if (startup) {
                String memento = config.getMemento();
                ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(new QualifiedName(STANDALONE_QUALIFIER, LAST_LAUNCH), memento);
            }
        } else {
            System.out.println("Import job failed");
            return null;
        }
        monitor.worked(1);
        return config;
    }

    protected static ILaunchConfigurationType getLaunchConfigType() {
        return DebugExecutable.getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.applicationLaunchType");
    }

    protected static ILaunchConfiguration createConfiguration(String bin, String arguments, String buildLog, boolean save) {
        Object config = null;
        try {
            String progName = bin;
            ILaunchConfigurationType configType = DebugExecutable.getLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugExecutable.getLaunchManager().generateLaunchConfigurationName(bin));
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", progName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "Executables");
            wc.setAttribute("org.eclipse.cdt.debug.application.launch.build.log", buildLog);
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            if (arguments != null) {
                wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", arguments);
            }
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", System.getProperty("user.dir"));
            config = save ? wc.doSave() : wc;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }
}

