/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core;

import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.autotools.core.AutotoolsNewMakeGenerator;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfigurationManager;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;

public class AutotoolsConfigurationBuilder
extends ACBuilder {
    public static final String BUILDER_NAME = "genmakebuilderV2";
    public static final String BUILDER_ID = String.valueOf(AutotoolsPlugin.getPluginId()) + "." + "genmakebuilderV2";
    public static final String OLD_BUILDER_ID = "org.eclipse.linuxtools.cdt.autotools.core.genmakebuilderV2";
    private static final String BUILD_STOPPED = "AutotoolsMakefileBuilder.message.stopped";
    private AutotoolsNewMakeGenerator generator = new AutotoolsNewMakeGenerator();

    protected boolean isCdtProjectCreated(IProject project) {
        ICProjectDescription des = CoreModel.getDefault().getProjectDescription(project, false);
        return des != null && !des.isCdtProjectCreating();
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        MultiStatus result;
        IProject project = this.getProject();
        if (!this.isCdtProjectCreated(project)) {
            return project.getReferencedProjects();
        }
        boolean bPerformBuild = true;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (!this.shouldBuild(kind, info)) {
            return new IProject[0];
        }
        if (kind == 9) {
            IAConfiguration acfg;
            IConfiguration cfg;
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                IResource res = delta.getResource();
                if (res != null) {
                    bPerformBuild = res.getProject().equals((Object)this.getProject());
                }
            } else {
                bPerformBuild = false;
            }
            if ((cfg = info.getDefaultConfiguration()) != null && ((acfg = AutotoolsConfigurationManager.getInstance().findCfg(project, cfg.getName())) == null || acfg.isDirty())) {
                bPerformBuild = true;
            }
        }
        if (bPerformBuild && (result = this.performMakefileGeneration(project, info, monitor)).getSeverity() == 4) {
            IConsole console = CCorePlugin.getDefault().getConsole();
            console.start(project);
            ConsoleOutputStream cos = console.getOutputStream();
            String errormsg = AutotoolsPlugin.getResourceString(BUILD_STOPPED);
            StringBuilder buf = new StringBuilder(errormsg);
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append("(").append(result.getMessage()).append(")");
            try {
                cos.write(buf.toString().getBytes());
                cos.flush();
                cos.close();
            }
            catch (IOException e) {
                AutotoolsPlugin.log(e);
            }
        }
        this.checkCancel(monitor);
        return this.getProject().getReferencedProjects();
    }

    protected void clean(IProgressMonitor monitor) {
        IProject project = this.getProject();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (this.shouldBuild(15, info)) {
            IConfiguration icfg = info.getDefaultConfiguration();
            if (icfg instanceof IMultiConfiguration) {
                IMultiConfiguration mcfg = (IMultiConfiguration)icfg;
                IConfiguration[] cfgs = (IConfiguration[])mcfg.getItems();
                int i = 0;
                while (i < cfgs.length) {
                    IAConfiguration cfg = AutotoolsConfigurationManager.getInstance().getConfiguration(project, icfg.getName());
                    cfg.setDirty(true);
                    ++i;
                }
            } else {
                IAConfiguration cfg = AutotoolsConfigurationManager.getInstance().getConfiguration(project, icfg.getName());
                cfg.setDirty(true);
            }
        }
    }

    protected MultiStatus performMakefileGeneration(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        MultiStatus result;
        try {
            this.generator.initialize(project, info, monitor);
            result = this.generator.regenerateMakefiles(false);
        }
        catch (CoreException e) {
            String errMsg = AutotoolsPlugin.getResourceString("MakeGenerator.didnt.generate");
            result = new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), 4, errMsg, (Throwable)e);
        }
        return result;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int kind, IManagedBuildInfo info) {
        IConfiguration cfg = info.getDefaultConfiguration();
        IBuilder builder = null;
        if (cfg != null) {
            builder = cfg.getEditableBuilder();
            switch (kind) {
                case 9: {
                    return builder.isAutoBuildEnable();
                }
                case 6: 
                case 10: {
                    return builder.isFullBuildEnabled() | builder.isIncrementalBuildEnabled();
                }
                case 15: {
                    return builder.isCleanBuildEnabled();
                }
            }
        }
        return true;
    }
}

