/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.editmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.common.ui.editmodel.EditModel;
import org.eclipse.bpel.common.ui.editmodel.ResourceListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceInfo {
    EditModel editModel;
    Resource resource;
    IFile file;
    ResourceListener resourceListener;
    Adapter resourceAdapter;
    long synchronizeStamp = 0L;
    Map loadOptions = new HashMap();
    protected int referenceCount = 0;
    protected boolean loading = false;
    protected boolean fileExists = false;

    ResourceInfo(EditModel anEditModel, IFile aFile) {
        this.editModel = anEditModel;
        this.file = aFile;
        this.resetSynchronizeStamp();
        this.resourceListener = new ResourceListener(this, this.file);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        this.resourceAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getEventType() == 1 && ResourceInfo.this.resource != null && msg.getNotifier() == ResourceInfo.this.resource && msg.getFeatureID(Resource.class) == 3) {
                    ResourceInfo.this.editModel.fireModelDirtyStateChanged(ResourceInfo.this);
                }
            }
        };
    }

    public IFile getFile() {
        return this.file;
    }

    protected boolean getFileExists() {
        return this.fileExists;
    }

    public boolean isDirty() {
        if (this.resource == null) {
            return false;
        }
        return this.resource.isModified();
    }

    public Resource getResource() {
        return this.resource;
    }

    protected void setResource(Resource aResource) {
        this.resource = aResource;
    }

    public Map getLoadOptions() {
        return this.loadOptions;
    }

    public void setLoadOptions(Map loadOptions) {
        this.loadOptions = loadOptions;
    }

    protected void move(IFile movedToFile) {
        this.editModel.removeResourceInfo(this);
        this.file = movedToFile;
        this.resource.setURI(URI.createPlatformResourceURI((String)this.file.getFullPath().toString()));
        this.resetSynchronizeStamp();
        this.resourceListener.setFile(movedToFile);
        this.editModel.addResourceInfo(this);
        this.editModel.fireModelLocationChanged(this, movedToFile);
    }

    protected void deleted() {
        if (this.editModel == null) {
            return;
        }
        this.editModel.fireModelDeleted(this);
    }

    protected void markersChanged(IMarkerDelta[] markerDelta) {
        if (this.editModel == null) {
            return;
        }
        this.editModel.fireModelMarkersChanged(this, markerDelta);
    }

    public void refresh() {
        if (this.getSynchronizeStamp() == this.getCurrentFileModified()) {
            return;
        }
        this.load();
        this.editModel.fireModelReloaded(this);
    }

    protected void dispose() {
        if (this.editModel == null) {
            return;
        }
        if (this.resource != null) {
            this.resource.eAdapters().clear();
        }
        this.editModel.removeResourceInfo(this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        if (this.resource != null) {
            this.resource.unload();
        }
        this.editModel = null;
        this.resource = null;
        this.resourceListener = null;
    }

    protected void load() {
        if (this.resource != null) {
            this.resource.unload();
        }
        try {
            this.loading = true;
            this.resource = this.editModel.getResourceSet().getResource(URI.createPlatformResourceURI((String)this.file.getFullPath().toString()), true);
        }
        finally {
            this.loading = false;
        }
        this.resourceLoaded();
    }

    protected void resourceLoaded() {
        if (this.loading) {
            return;
        }
        this.resetSynchronizeStamp();
        this.resource.eAdapters().add((Object)this.resourceAdapter);
        this.fileExists = this.file.exists();
    }

    public void save() throws IOException {
        this.getResource().save(this.getLoadOptions());
        this.fileExists = true;
        this.resetSynchronizeStamp();
    }

    public void saveAs(IFile savedFile) throws IOException {
        this.move(savedFile);
        this.save();
    }

    public void resetSynchronizeStamp() {
        this.synchronizeStamp = this.getCurrentFileModified();
    }

    public long getSynchronizeStamp() {
        return this.synchronizeStamp;
    }

    private long getCurrentFileModified() {
        return this.file.getLocation().toFile().lastModified();
    }
}

