/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.debug.internal.core.vm.VMBreakPoint;
import org.eclipse.birt.report.debug.internal.core.vm.VMBreakPointListener;
import org.eclipse.birt.report.debug.internal.core.vm.VMConstants;
import org.eclipse.birt.report.debug.internal.core.vm.VMContextData;
import org.eclipse.birt.report.debug.internal.core.vm.VMListener;
import org.eclipse.birt.report.debug.internal.core.vm.VMStackFrame;
import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsContextData;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsDebugger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.debug.Debugger;

public class ReportVM
implements VMConstants {
    private List vmListeners = new ArrayList();
    private List bpListeners = new ArrayList();
    private List deferredBreakPoints = new LinkedList();
    private Object monitor = new Object();
    private boolean suspended;
    private boolean isStartSuspended;
    private boolean isAttached;
    private volatile String evalRequest;
    private volatile Object evalResult;
    private volatile VMContextData currentContextData;
    private volatile int currentVMState = 0;
    private JsDebugger jsDebugger;
    private ContextFactory.Listener factoryListener;

    public void attach(Context cx) {
        this.attach(cx, false);
    }

    public void attach(Context cx, boolean startSuspended) {
        Object cxData;
        this.isStartSuspended = startSuspended;
        this.jsDebugger = new JsDebugger(this);
        this.isAttached = true;
        this.factoryListener = new ContextFactory.Listener(){

            public void contextCreated(Context cx) {
                JsContextData cxData = new JsContextData();
                cx.setDebugger((Debugger)ReportVM.this.jsDebugger, (Object)cxData);
                cx.setGeneratingDebug(true);
                cx.setOptimizationLevel(-1);
            }

            public void contextReleased(Context cx) {
                cx.setDebugger(null, null);
            }
        };
        if (cx.getDebugger() == null) {
            cxData = new JsContextData();
            cx.setDebugger((Debugger)this.jsDebugger, cxData);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
            this.addDeferredBreakPoints();
        }
        if (startSuspended) {
            this.currentVMState = 5;
            cxData = cx.getDebuggerContextData();
            if (cxData instanceof JsContextData) {
                ((JsContextData)cxData).setBreakOnStart(true);
            }
        } else {
            this.currentVMState = 9;
            this.dispatchEvent(9, null);
        }
    }

    public void detach(Context cx) {
        Debugger dbg;
        if (!this.isTerminated()) {
            this.terminate();
        }
        if ((dbg = cx.getDebugger()) instanceof JsDebugger) {
            cx.setDebugger(null, null);
        }
        this.isAttached = false;
        if (this.jsDebugger != null) {
            this.jsDebugger.dispose();
            this.jsDebugger = null;
        }
        if (this.factoryListener != null) {
            cx.getFactory().removeListener(this.factoryListener);
            this.factoryListener = null;
        }
    }

    public void dispose(Context cx) {
        this.detach(cx);
        this.vmListeners.clear();
        this.bpListeners.clear();
        this.deferredBreakPoints.clear();
    }

    public VMStackFrame[] getStackFrames() {
        if (this.isSuspended() && this.currentContextData != null) {
            VMStackFrame[] frames = new VMStackFrame[this.currentContextData.frameCount()];
            int i = 0;
            while (i < frames.length) {
                frames[i] = this.currentContextData.getFrame(i);
                ++i;
            }
            return frames;
        }
        return NO_FRAMES;
    }

    public VMStackFrame getStackFrame(int index) {
        if (index < 0 || !this.isSuspended()) {
            return null;
        }
        if (this.currentContextData != null && index < this.currentContextData.frameCount()) {
            return this.currentContextData.getFrame(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VMValue evaluate(String expression) {
        if (this.isSuspended() && expression != null && this.currentContextData != null && this.currentContextData.getCurrentFrame() != null) {
            Object object = this.monitor;
            synchronized (object) {
                this.evalRequest = expression;
                this.monitor.notify();
                do {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                } while (!this.isTerminated() && this.evalRequest != null);
                return (VMValue)this.evalResult;
            }
        }
        return null;
    }

    public VMVariable[] getVariables() {
        VMStackFrame frame;
        if (this.isSuspended() && this.currentContextData != null && (frame = this.currentContextData.getCurrentFrame()) != null) {
            return frame.getVariables();
        }
        return NO_VARS;
    }

    int currentState() {
        return this.currentVMState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void interrupt(VMContextData contextData, int interruptState) {
        var3_3 = this.monitor;
        synchronized (var3_3) {
            block21: {
                this.suspended = true;
                this.currentVMState = interruptState;
                this.evalRequest = null;
                if (this.isStartSuspended) {
                    this.isStartSuspended = false;
                    this.dispatchEvent(9, contextData);
                } else {
                    this.dispatchEvent(this.currentVMState, contextData);
                }
                while (true) lbl-1000:
                // 3 sources

                {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException v0) {
                        Thread.currentThread().interrupt();
                        this.suspended = false;
                        return;
                    }
                    if (this.evalRequest == null) break block21;
                    this.evalResult = null;
                    try {
                        this.evalResult = contextData.getCurrentFrame().evaluate(this.evalRequest);
                    }
                    finally {
                        this.evalRequest = null;
                        this.monitor.notify();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    this.suspended = false;
                }
            }
            if (this.isTerminated()) {
                return;
            }
        }
        this.dispatchEvent(11, contextData);
        switch (this.currentVMState) {
            case 1: {
                ((JsContextData)contextData).breakNextLine(contextData.frameCount());
                break;
            }
            case 2: {
                ((JsContextData)contextData).breakNextLine(-1);
                break;
            }
            case 3: {
                if (contextData.frameCount() <= 1) break;
                ((JsContextData)contextData).breakNextLine(contextData.frameCount() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.monitor;
        synchronized (object) {
            this.currentVMState = 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.monitor;
        synchronized (object) {
            this.currentVMState = 4;
            this.monitor.notifyAll();
        }
    }

    public void resume(VMBreakPoint bp, boolean forceBreak) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step() {
        Object object = this.monitor;
        synchronized (object) {
            this.currentVMState = 1;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepInto() {
        Object object = this.monitor;
        synchronized (object) {
            this.currentVMState = 2;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOut() {
        Object object = this.monitor;
        synchronized (object) {
            this.currentVMState = 3;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.monitor;
        synchronized (object) {
            this.currentVMState = 10;
            this.monitor.notifyAll();
            this.dispatchEvent(10, null);
        }
    }

    public boolean isSuspended() {
        return this.suspended && this.currentVMState != 10;
    }

    public boolean isTerminated() {
        return this.currentVMState == 10;
    }

    public void addVMListener(VMListener listener) {
        if (!this.vmListeners.contains(listener)) {
            this.vmListeners.add(listener);
        }
    }

    public void removeVMListener(VMListener listener) {
        this.vmListeners.remove(listener);
    }

    public void addBreakPointListener(VMBreakPointListener listener) {
        if (!this.bpListeners.contains(listener)) {
            this.bpListeners.add(listener);
        }
    }

    public void removeBreakPointListener(VMBreakPointListener listener) {
        this.bpListeners.remove(listener);
    }

    public void addBreakPoint(VMBreakPoint bp) {
        if (this.isAttached) {
            this.notifyBreakPointChange(bp, 1);
        } else if (!this.deferredBreakPoints.contains(bp)) {
            this.deferredBreakPoints.add(bp);
        }
    }

    public void removeBreakPoint(VMBreakPoint bp) {
        if (this.isAttached) {
            this.notifyBreakPointChange(bp, 2);
        } else if (this.deferredBreakPoints.contains(bp)) {
            this.deferredBreakPoints.remove(bp);
        }
    }

    public void modifyBreakPoint(VMBreakPoint bp) {
        if (this.isAttached) {
            this.notifyBreakPointChange(bp, 3);
        } else {
            this.deferredBreakPoints.contains(bp);
        }
    }

    public void clearBreakPoints() {
        if (this.isAttached) {
            this.notifyBreakPointChange(null, 4);
        } else {
            this.deferredBreakPoints.clear();
        }
    }

    private void addDeferredBreakPoints() {
        int i = 0;
        while (i < this.deferredBreakPoints.size()) {
            this.notifyBreakPointChange((VMBreakPoint)this.deferredBreakPoints.get(i), 1);
            ++i;
        }
        this.deferredBreakPoints.clear();
    }

    private void notifyBreakPointChange(VMBreakPoint bp, int command) {
        switch (command) {
            case 1: {
                int i = 0;
                while (i < this.bpListeners.size()) {
                    VMBreakPointListener bpListener = (VMBreakPointListener)this.bpListeners.get(i);
                    bpListener.breakPointAdded(bp);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.bpListeners.size()) {
                    VMBreakPointListener bpListener = (VMBreakPointListener)this.bpListeners.get(i);
                    bpListener.breakPointRemoved(bp);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.bpListeners.size()) {
                    VMBreakPointListener bpListener = (VMBreakPointListener)this.bpListeners.get(i);
                    bpListener.breakPointChanged(bp);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.bpListeners.size()) {
                    VMBreakPointListener bpListener = (VMBreakPointListener)this.bpListeners.get(i);
                    bpListener.breakPointCleared();
                    ++i;
                }
                break;
            }
        }
    }

    private void dispatchEvent(int event, VMContextData contextData) {
        this.currentContextData = contextData;
        int i = 0;
        while (i < this.vmListeners.size()) {
            ((VMListener)this.vmListeners.get(i)).handleEvent(event, contextData);
            ++i;
        }
    }
}

