/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.ui.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.data.oda.mongodb.impl.MDbQuery;
import org.eclipse.birt.data.oda.mongodb.impl.MongoDBDriver;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryModel;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.ui.i18n.Messages;
import org.eclipse.birt.data.oda.mongodb.ui.impl.MDBCommandExpressionBuilder;
import org.eclipse.birt.data.oda.mongodb.ui.impl.MDBQueryExpressionBuilder;
import org.eclipse.birt.data.oda.mongodb.ui.impl.MDBSortExpressionBuilder;
import org.eclipse.birt.data.oda.mongodb.ui.impl.MongoDBAdvancedSettingsDialog;
import org.eclipse.birt.data.oda.mongodb.ui.util.FieldEntryWrapper;
import org.eclipse.birt.data.oda.mongodb.ui.util.UIHelper;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.DesignerStateContent;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class MongoDBDataSetWizardPage
extends DataSetWizardPage {
    private static final String EMPTY_STRING = "";
    private boolean modelChanged;
    private ScrolledComposite sComposite;
    private Group commandOpArea;
    private Text DBNameText;
    private Text docNumText;
    private Combo opTypeCombo;
    private Combo collectionCombo;
    private Button addBtn;
    private Button addAllBtn;
    private Button removeBtn;
    private Button removeAllBtn;
    private Button upBtn;
    private Button downBtn;
    private Button sysCollOption;
    private Button refreshBtn;
    private Button cmdExprBtn;
    private Button findFieldsBtn;
    private Button queryExprBtn;
    private Button sortExprBtn;
    private TreeViewer availableFieldsViewer;
    private TableViewer selectedFieldsTable;
    private Label opTypeLabel;
    private Label DBNameLabel;
    private Menu menu;
    private MenuItem menuRemove;
    private MenuItem menuRemoveAll;
    protected static Image warningImage;
    private List<String> collectionList;
    private List<MDbMetaData.FieldMetaData> selectedFields;
    private List<MDbMetaData.FieldMetaData> allAvailableFields;
    private DataSetDesign dataSetDesign;
    private String collectionName;
    private String oldCollectionName;
    private String queryText;
    private String cmdExprValue;
    private String queryExpr;
    private String sortExpr;
    private QueryProperties.CommandOperationType opType;
    private int searchLimit;
    private boolean includeSysColl;
    private MDbMetaData metaData;
    private FieldEntryWrapper treeEntry;
    private QueryProperties queryProps;
    private static String DEFAULT_MESSAGE;
    private static String DESIGNER_STATE_SEPARATOR;
    boolean flag = false;
    private SelectionListener collectionSelectionListener;
    private ModifyListener collectionModifyListener;
    private SelectionListener opTypeSelectionListener;

    static {
        DEFAULT_MESSAGE = Messages.getString("MongoDBDataSetWizardPage.message.default");
        DESIGNER_STATE_SEPARATOR = ",";
    }

    public MongoDBDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public MongoDBDataSetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.sComposite = new ScrolledComposite(parent, 768);
        this.sComposite.setLayout((Layout)new GridLayout());
        this.sComposite.setLayoutData((Object)new GridData(1808));
        this.sComposite.setMinWidth(600);
        this.sComposite.setExpandHorizontal(true);
        Composite mainComposite = new Composite((Composite)this.sComposite, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        mainComposite.setLayoutData((Object)gridData);
        this.createTopArea(mainComposite);
        this.createFieldsSelectionArea(mainComposite);
        this.createBottomArea(mainComposite);
        Point size = mainComposite.computeSize(-1, -1);
        mainComposite.setSize(size.x, size.y);
        this.sComposite.setContent((Control)mainComposite);
        this.setControl((Control)this.sComposite);
        this.setPageComplete(false);
        try {
            this.initPageInfos();
        }
        catch (OdaException e) {
            this.initializeControl();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String errorMsg = UIHelper.getUserErrorMessage("MongoDBDataSetWizardPage.MessageDialog.ErrorMessage.InitPage", (Exception)e);
                    ExceptionHandler.showException((Shell)MongoDBDataSetWizardPage.this.sComposite.getShell(), (String)Messages.getString("MongoDBDataSetWizardPage.MessageDialog.title.GeneralError"), (String)errorMsg, (Throwable)e);
                }
            });
            return;
        }
        this.initializeControl();
        this.resetLabelWidth();
        this.modelChanged = false;
        UIHelper.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_MongoDB_Dataset_ID");
    }

    private void createBottomArea(Composite mainComposite) {
        Composite bottomArea = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 5;
        layout.marginTop = 5;
        layout.horizontalSpacing = 15;
        bottomArea.setLayout((Layout)layout);
        bottomArea.setLayoutData((Object)new GridData(768));
        this.queryExprBtn = new Button(bottomArea, 8);
        this.queryExprBtn.setText(Messages.getString("MongoDBDataSetWizardPage.Button.QueryExpression"));
        this.queryExprBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MDBQueryExpressionBuilder queryExprDialog = new MDBQueryExpressionBuilder(Display.getDefault().getActiveShell());
                queryExprDialog.setExpressionText(MongoDBDataSetWizardPage.this.queryExpr);
                if (queryExprDialog.open() == 0) {
                    String oldQueryExpr = MongoDBDataSetWizardPage.this.queryExpr;
                    MongoDBDataSetWizardPage.this.queryExpr = queryExprDialog.getExprText();
                    if (MongoDBDataSetWizardPage.this.queryExpr != null && !MongoDBDataSetWizardPage.this.queryExpr.equals(oldQueryExpr)) {
                        MongoDBDataSetWizardPage.this.modelChanged = true;
                        MongoDBDataSetWizardPage.this.queryProps.setFindQueryExpr(MongoDBDataSetWizardPage.this.queryExpr);
                        MongoDBDataSetWizardPage.this.validateData();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.sortExprBtn = new Button(bottomArea, 8);
        this.sortExprBtn.setText(Messages.getString("MongoDBDataSetWizardPage.Button.SortExpression"));
        this.sortExprBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MDBSortExpressionBuilder sortExprDialog = new MDBSortExpressionBuilder(Display.getDefault().getActiveShell());
                sortExprDialog.setExpressionText(MongoDBDataSetWizardPage.this.sortExpr);
                if (sortExprDialog.open() == 0) {
                    String oldSortExpr = MongoDBDataSetWizardPage.this.sortExpr;
                    MongoDBDataSetWizardPage.this.sortExpr = sortExprDialog.getExprText();
                    if (MongoDBDataSetWizardPage.this.sortExpr != null && !MongoDBDataSetWizardPage.this.sortExpr.equals(oldSortExpr)) {
                        MongoDBDataSetWizardPage.this.modelChanged = true;
                        MongoDBDataSetWizardPage.this.queryProps.setSortExpr(MongoDBDataSetWizardPage.this.sortExpr);
                        MongoDBDataSetWizardPage.this.validateData();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button advancedSettingsBtn = new Button(bottomArea, 8);
        advancedSettingsBtn.setText(Messages.getString("MongoDBDataSetWizardPage.Button.AdvancedSettings"));
        advancedSettingsBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBAdvancedSettingsDialog settingsDialog = new MongoDBAdvancedSettingsDialog(Display.getDefault().getActiveShell());
                settingsDialog.initQueryProps(MongoDBDataSetWizardPage.this.queryProps);
                if (settingsDialog.open() == 0) {
                    settingsDialog.updateQueryProperties(MongoDBDataSetWizardPage.this.queryProps);
                    try {
                        MongoDBDataSetWizardPage.this.synchronizeSearchLimit();
                    }
                    catch (OdaException e1) {
                        MongoDBDataSetWizardPage.this.handleNoFieldsException((Exception)((Object)e1));
                    }
                    MongoDBDataSetWizardPage.this.modelChanged = true;
                    MongoDBDataSetWizardPage.this.validateData();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void synchronizeSearchLimit() throws OdaException {
        MessageDialog infoDialog;
        if (!this.queryProps.hasRuntimeMetaDataSearchLimit()) {
            return;
        }
        int runtimeLimit = this.queryProps.getRuntimeMetaDataSearchLimit();
        if (runtimeLimit < this.searchLimit && (infoDialog = new MessageDialog(this.sComposite.getShell(), Messages.getString("MongoDBAdvancedSettingsDialog.MessageDialog.synchronizeSearchLimit.title"), null, Messages.getString("MongoDBAdvancedSettingsDialog.MessageDialog.synchronizeSearchLimit.message"), 2, new String[]{Messages.getString("MongoDBAdvancedSettingsDialog.MessageDialog.synchronizeSearchLimit.button")}, 0)).open() == 0) {
            this.searchLimit = runtimeLimit;
            this.docNumText.setText(String.valueOf(this.searchLimit));
            this.updateAvailableFieldsList();
            this.refreshAvailableFieldsViewer();
            this.availableFieldsViewer.expandToLevel(2);
            this.refreshSelectedFieldsViewer();
            this.selectedFieldsTable.getTable().deselectAll();
            this.autoSelectRootItem();
        }
    }

    private void createFieldsSelectionArea(Composite mainComposite) {
        Composite fieldsSelectionArea = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginRight = 20;
        layout.horizontalSpacing = 5;
        fieldsSelectionArea.setLayout((Layout)layout);
        fieldsSelectionArea.setLayoutData((Object)new GridData(768));
        this.createLeftAvailabeFieldsArea(fieldsSelectionArea);
        this.createCenterBtnOperationArea(fieldsSelectionArea);
        this.createRightSelectedFieldsArea(fieldsSelectionArea);
    }

    private void createLeftAvailabeFieldsArea(Composite fieldsSelectionArea) {
        Composite leftComposite = new Composite(fieldsSelectionArea, 0);
        GridLayout layout = new GridLayout();
        leftComposite.setLayout((Layout)layout);
        leftComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(leftComposite, 0);
        label.setText(Messages.getString("MongoDBDataSetWizardPage.label.AvailableFields"));
        this.availableFieldsViewer = new TreeViewer(leftComposite, 2050);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 180;
        this.availableFieldsViewer.getTree().setLayoutData((Object)gd);
        FieldsTreeProvider provider = new FieldsTreeProvider();
        this.availableFieldsViewer.setContentProvider((IContentProvider)provider);
        this.availableFieldsViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.availableFieldsViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSetWizardPage.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createRightSelectedFieldsArea(Composite fieldsSelectionArea) {
        Composite rightComposite = new Composite(fieldsSelectionArea, 0);
        GridLayout layout = new GridLayout();
        rightComposite.setLayout((Layout)layout);
        rightComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(rightComposite, 0);
        label.setText(Messages.getString("MongoDBDataSetWizardPage.label.SelectedFields"));
        this.selectedFieldsTable = new TableViewer(rightComposite, 68354);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 120;
        this.selectedFieldsTable.getTable().setLayoutData((Object)gd);
        this.selectedFieldsTable.getTable().setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.selectedFieldsTable.getTable(), 16384);
        column1.setResizable(true);
        column1.setWidth(20);
        TableColumn column2 = new TableColumn(this.selectedFieldsTable.getTable(), 16384);
        column2.setText(Messages.getString("MongoDBDataSetWizardPage.HeaderText.SelectedFields"));
        column2.setResizable(true);
        column2.setWidth(180);
        TableProvider tableProvider = new TableProvider();
        this.selectedFieldsTable.setContentProvider((IContentProvider)tableProvider);
        this.selectedFieldsTable.setLabelProvider((IBaseLabelProvider)tableProvider);
        this.selectedFieldsTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSetWizardPage.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.selectedFieldsTable.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    MongoDBDataSetWizardPage.this.doRemoveSelectedFields();
                }
            }
        });
        this.createMenuItems();
    }

    private void createMenuItems() {
        this.menu = new Menu((Control)this.selectedFieldsTable.getTable());
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MongoDBDataSetWizardPage.this.selectedFieldsTable.cancelEditing();
            }
        });
        this.menuRemove = new MenuItem(this.menu, 0);
        this.menuRemove.setText(Messages.getString("MongoDBDataSetWizardPage.menuItem.remove"));
        this.menuRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSetWizardPage.this.doRemoveSelectedFields();
            }
        });
        this.menuRemoveAll = new MenuItem(this.menu, 0);
        this.menuRemoveAll.setText(Messages.getString("MongoDBDataSetWizardPage.menuItem.removeAll"));
        this.menuRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSetWizardPage.this.doRemoveAllFieldsFromTablePanel();
            }
        });
        this.selectedFieldsTable.getTable().setMenu(this.menu);
    }

    private void createCenterBtnOperationArea(Composite fieldsSelectionArea) {
        Composite btnComposite = new Composite(fieldsSelectionArea, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 12;
        layout.marginHeight = 60;
        btnComposite.setLayout((Layout)layout);
        btnComposite.setLayoutData((Object)new GridData(1040));
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.widthHint = 36;
        this.addBtn = new Button(btnComposite, 8);
        this.addBtn.setText(">");
        this.addBtn.setLayoutData((Object)gd);
        this.addBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSetWizardPage.this.doAddSelectedFields(MongoDBDataSetWizardPage.this.availableFieldsViewer.getTree().getSelection());
                MongoDBDataSetWizardPage.this.availableFieldsViewer.refresh();
                MongoDBDataSetWizardPage.this.selectedFieldsTable.refresh();
                MongoDBDataSetWizardPage.this.deselectAll();
                MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().setSelection(MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().getItemCount() - 1);
                MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().setFocus();
                MongoDBDataSetWizardPage.this.updateButtons();
                MongoDBDataSetWizardPage.this.validateData();
                MongoDBDataSetWizardPage.this.modelChanged = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addAllBtn = new Button(btnComposite, 8);
        this.addAllBtn.setText(">>");
        this.addAllBtn.setLayoutData((Object)gd);
        this.addAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoDBDataSetWizardPage.this.availableFieldsViewer.getTree().getSelectionCount() <= 0) {
                    return;
                }
                if (MongoDBDataSetWizardPage.this.availableFieldsViewer.getTree().getSelection()[0].getData() instanceof MDbMetaData.FieldMetaData) {
                    MongoDBDataSetWizardPage.this.doAddAllChildrenField((MDbMetaData.FieldMetaData)MongoDBDataSetWizardPage.this.availableFieldsViewer.getTree().getSelection()[0].getData(), false);
                } else if (MongoDBDataSetWizardPage.this.availableFieldsViewer.getTree().getSelection()[0].getData() instanceof FieldEntryWrapper) {
                    MongoDBDataSetWizardPage.this.doAddAllFields();
                }
                MongoDBDataSetWizardPage.this.updateButtons();
                MongoDBDataSetWizardPage.this.availableFieldsViewer.refresh();
                MongoDBDataSetWizardPage.this.selectedFieldsTable.refresh();
                MongoDBDataSetWizardPage.this.deselectAll();
                MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().setSelection(MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().getItemCount() - 1);
                MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().setFocus();
                MongoDBDataSetWizardPage.this.updateButtons();
                MongoDBDataSetWizardPage.this.validateData();
                MongoDBDataSetWizardPage.this.modelChanged = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeBtn = new Button(btnComposite, 8);
        this.removeBtn.setText("<");
        this.removeBtn.setLayoutData((Object)gd);
        this.removeBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSetWizardPage.this.doRemoveSelectedFields();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeAllBtn = new Button(btnComposite, 8);
        this.removeAllBtn.setText("<<");
        this.removeAllBtn.setLayoutData((Object)gd);
        this.removeAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSetWizardPage.this.doRemoveAllFieldsFromTablePanel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData upBtnGd = new GridData();
        upBtnGd.verticalIndent = 18;
        upBtnGd.widthHint = 36;
        this.upBtn = new Button(btnComposite, 8);
        this.upBtn.setText("^");
        this.upBtn.setLayoutData((Object)upBtnGd);
        this.upBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                if (MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().getSelectionCount() == 1 && (index = MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().getSelectionIndex()) > 0) {
                    MDbMetaData.FieldMetaData field = (MDbMetaData.FieldMetaData)MongoDBDataSetWizardPage.this.selectedFields.get(index);
                    MongoDBDataSetWizardPage.this.selectedFields.set(index, (MDbMetaData.FieldMetaData)MongoDBDataSetWizardPage.this.selectedFields.get(index - 1));
                    MongoDBDataSetWizardPage.this.selectedFields.set(index - 1, field);
                    MongoDBDataSetWizardPage.this.selectedFieldsTable.refresh();
                    MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().select(index - 1);
                    MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().setFocus();
                    MongoDBDataSetWizardPage.this.updateButtons();
                    MongoDBDataSetWizardPage.this.modelChanged = true;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.downBtn = new Button(btnComposite, 8);
        this.downBtn.setText("v");
        this.downBtn.setLayoutData((Object)gd);
        this.downBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                if (MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().getSelectionCount() == 1 && (index = MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().getSelectionIndex()) >= 0 && index < MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().getItemCount() - 1) {
                    MDbMetaData.FieldMetaData field = (MDbMetaData.FieldMetaData)MongoDBDataSetWizardPage.this.selectedFields.get(index);
                    MongoDBDataSetWizardPage.this.selectedFields.set(index, (MDbMetaData.FieldMetaData)MongoDBDataSetWizardPage.this.selectedFields.get(index + 1));
                    MongoDBDataSetWizardPage.this.selectedFields.set(index + 1, field);
                    MongoDBDataSetWizardPage.this.selectedFieldsTable.refresh();
                    MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().select(index + 1);
                    MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().setFocus();
                    MongoDBDataSetWizardPage.this.updateButtons();
                    MongoDBDataSetWizardPage.this.modelChanged = true;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void doAddAllChildrenField(MDbMetaData.FieldMetaData field, boolean includeCurrent) {
        if (includeCurrent || !field.hasChildDocuments()) {
            this.addSingleField(field);
        }
        if (field.hasChildDocuments()) {
            MDbMetaData.DocumentsMetaData dmd = field.getChildMetaData();
            for (String name : dmd.getFieldNames()) {
                this.doAddAllChildrenField(dmd.getFieldMetaData(name), false);
            }
        }
    }

    private void doAddSelectedFields(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            this.addSingleTreeItem(items[i]);
            ++i;
        }
    }

    private void addSingleTreeItem(TreeItem item) {
        if (item.getData() instanceof MDbMetaData.FieldMetaData) {
            this.addSingleField((MDbMetaData.FieldMetaData)item.getData());
        }
    }

    private void addSingleField(MDbMetaData.FieldMetaData field) {
        int i = 0;
        while (i < this.selectedFields.size()) {
            if (field.getFullDisplayName().equals(this.selectedFields.get(i).getFullDisplayName())) {
                return;
            }
            ++i;
        }
        this.selectedFields.add(field);
    }

    private void doAddAllFields() {
        int i = 0;
        while (i < this.allAvailableFields.size()) {
            this.doAddAllChildrenField(this.allAvailableFields.get(i), false);
            ++i;
        }
    }

    private void doRemoveSelectedFields(TableItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof MDbMetaData.FieldMetaData) {
                this.doRemoveSelectedField((MDbMetaData.FieldMetaData)items[i].getData());
            }
            ++i;
        }
    }

    private void doRemoveSelectedField(MDbMetaData.FieldMetaData field) {
        this.selectedFields.remove(field);
    }

    private void doRemoveAllFieldsFromTablePanel() {
        this.doRemoveSelectedFields(this.selectedFieldsTable.getTable().getItems());
        this.availableFieldsViewer.refresh();
        this.selectedFieldsTable.refresh();
        this.deselectAll();
        this.validateData();
        this.updateButtons();
        this.modelChanged = true;
    }

    private void createTopArea(Composite mainComposite) {
        Composite topArea = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 5;
        layout.marginRight = 30;
        topArea.setLayout((Layout)layout);
        topArea.setLayoutData((Object)new GridData(768));
        this.createDBNameArea(topArea);
        this.createCollectionSelectionArea(topArea);
        this.createCommandOpArea(topArea);
        this.createDocNumSettingArea(topArea);
        this.resetButtonsWidth();
    }

    private void createDBNameArea(Composite topArea) {
        Composite composite = new Composite(topArea, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.DBNameLabel = new Label(composite, 0);
        this.DBNameLabel.setText(Messages.getString("MongoDBDataSetWizardPage.label.DBName"));
        this.DBNameText = new Text(composite, 0);
        this.DBNameText.setLayoutData((Object)new GridData(768));
        this.DBNameText.setEnabled(false);
    }

    private void resetLabelWidth() {
        int width = this.opTypeLabel.computeSize((int)-1, (int)-1).x;
        width = this.getMaxWidth((Control)this.sysCollOption, width);
        GridData labelGd = new GridData();
        labelGd.widthHint = width;
        this.DBNameLabel.setLayoutData((Object)labelGd);
        this.opTypeLabel.setLayoutData((Object)labelGd);
        this.sysCollOption.setLayoutData((Object)labelGd);
    }

    private void resetButtonsWidth() {
        int width = this.getMaxWidth((Control)this.refreshBtn, 60);
        width = this.getMaxWidth((Control)this.cmdExprBtn, width);
        width = this.getMaxWidth((Control)this.findFieldsBtn, width) + 10;
        GridData btnGd = new GridData();
        btnGd.widthHint = width;
        this.cmdExprBtn.setLayoutData((Object)btnGd);
        this.refreshBtn.setLayoutData((Object)btnGd);
        this.findFieldsBtn.setLayoutData((Object)btnGd);
    }

    private int getMaxWidth(Control control, int width) {
        int size = control.computeSize((int)-1, (int)-1).x;
        return size > width ? size : width;
    }

    private void createDocNumSettingArea(Composite topArea) {
        Composite composite = new Composite(topArea, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 12;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label docNumLabel = new Label(composite, 0);
        docNumLabel.setText(Messages.getString("MongoDBDataSetWizardPage.label.DocumentNumber"));
        this.docNumText = new Text(composite, 2048);
        GridData txtGd = new GridData(768);
        this.docNumText.setLayoutData((Object)txtGd);
        this.docNumText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MongoDBDataSetWizardPage.this.isNumber(MongoDBDataSetWizardPage.this.docNumText.getText().trim())) {
                    MongoDBDataSetWizardPage.this.searchLimit = Integer.parseInt(MongoDBDataSetWizardPage.this.docNumText.getText().trim());
                    MongoDBDataSetWizardPage.this.modelChanged = true;
                }
                MongoDBDataSetWizardPage.this.validateData();
            }
        });
        this.findFieldsBtn = new Button(composite, 8);
        this.findFieldsBtn.setText(Messages.getString("MongoDBDataSetWizardPage.Button.FindFields"));
        this.findFieldsBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MongoDBDataSetWizardPage.this.updateAvailableFieldsList();
                    MongoDBDataSetWizardPage.this.refreshAvailableFieldsViewer();
                    MongoDBDataSetWizardPage.this.availableFieldsViewer.expandToLevel(2);
                    MongoDBDataSetWizardPage.this.refreshSelectedFieldsViewer();
                    MongoDBDataSetWizardPage.this.selectedFieldsTable.getTable().deselectAll();
                    MongoDBDataSetWizardPage.this.autoSelectRootItem();
                }
                catch (OdaException ex) {
                    MongoDBDataSetWizardPage.this.handleNoFieldsException((Exception)((Object)ex));
                }
                MongoDBDataSetWizardPage.this.validateData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createCollectionSelectionArea(Composite topArea) {
        Group collGroup = new Group(topArea, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 12;
        collGroup.setLayout((Layout)layout);
        collGroup.setLayoutData((Object)new GridData(768));
        collGroup.setText(Messages.getString("MongoDBDataSetWizardPage.label.DBCollection"));
        this.sysCollOption = new Button((Composite)collGroup, 32);
        this.sysCollOption.setText(Messages.getString("MongoDBDataSetWizardPage.Button.text.IncludeSystemCollection"));
        this.sysCollOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBDataSetWizardPage.this.includeSysColl = MongoDBDataSetWizardPage.this.sysCollOption.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.collectionCombo = new Combo((Composite)collGroup, 2048);
        this.collectionCombo.setLayoutData((Object)new GridData(768));
        this.collectionCombo.setVisibleItemCount(20);
        this.collectionSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoDBDataSetWizardPage.this.selectedFields.size() == 0) {
                    if (!MongoDBDataSetWizardPage.this.collectionCombo.getText().equals(MongoDBDataSetWizardPage.this.oldCollectionName)) {
                        MongoDBDataSetWizardPage.this.modelChanged = true;
                        MongoDBDataSetWizardPage.this.collectionName = MongoDBDataSetWizardPage.this.collectionCombo.getText().trim();
                        MongoDBDataSetWizardPage.this.oldCollectionName = MongoDBDataSetWizardPage.this.collectionName;
                        MongoDBDataSetWizardPage.this.resetOpTypeComboItems();
                        MongoDBDataSetWizardPage.this.doUpdateAvailableFieldsArea();
                        MongoDBDataSetWizardPage.this.validateData();
                    }
                } else if (!MongoDBDataSetWizardPage.this.collectionCombo.getText().equals(MongoDBDataSetWizardPage.this.oldCollectionName)) {
                    if (MessageDialog.open((int)3, (Shell)MongoDBDataSetWizardPage.this.getShell(), (String)Messages.getString("MongoDBDataSetWizardPage.MessageBox.title.PromptToKeepSelections"), (String)Messages.getString("MongoDBDataSetWizardPage.MessageBox.message.PromptToKeepSelections"), (int)0)) {
                        MongoDBDataSetWizardPage.this.selectedFields.clear();
                        MongoDBDataSetWizardPage.this.modelChanged = true;
                        MongoDBDataSetWizardPage.this.collectionName = MongoDBDataSetWizardPage.this.collectionCombo.getText().trim();
                        MongoDBDataSetWizardPage.this.resetOpTypeComboItems();
                        MongoDBDataSetWizardPage.this.doUpdateAvailableFieldsArea();
                        MongoDBDataSetWizardPage.this.validateData();
                    } else {
                        MongoDBDataSetWizardPage.this.collectionCombo.setText(MongoDBDataSetWizardPage.this.oldCollectionName);
                    }
                }
                MongoDBDataSetWizardPage.this.resetExprBtnStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.collectionModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBDataSetWizardPage.this.oldCollectionName = MongoDBDataSetWizardPage.this.collectionName;
                MongoDBDataSetWizardPage.this.collectionName = MongoDBDataSetWizardPage.this.collectionCombo.getText().trim();
                MongoDBDataSetWizardPage.this.resetOpTypeComboItems();
                MongoDBDataSetWizardPage.this.modelChanged = true;
                MongoDBDataSetWizardPage.this.resetExprBtnStatus();
                MongoDBDataSetWizardPage.this.validateData();
            }
        };
        this.addCollectionComboListeners();
        this.refreshBtn = new Button((Composite)collGroup, 8);
        this.refreshBtn.setText(Messages.getString("MongoDBDataSetWizardPage.Button.Refresh"));
        this.refreshBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MongoDBDataSetWizardPage.this.collectionList = MongoDBDataSetWizardPage.this.metaData.getCollectionsList(!MongoDBDataSetWizardPage.this.includeSysColl);
                    }
                });
                MongoDBDataSetWizardPage.this.resetCollectionComboItems();
                MongoDBDataSetWizardPage.this.collectionName = MongoDBDataSetWizardPage.this.collectionCombo.getText().trim();
                MongoDBDataSetWizardPage.this.resetOpTypeComboItems();
                MongoDBDataSetWizardPage.this.validateData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void resetCollectionComboItems() {
        this.removeCollectionComboListeners();
        this.oldCollectionName = this.collectionCombo.getText().trim();
        this.collectionCombo.removeAll();
        int i = 0;
        while (i < this.collectionList.size()) {
            this.collectionCombo.add(this.collectionList.get(i));
            ++i;
        }
        if (this.collectionCombo.indexOf(this.oldCollectionName) >= 0) {
            this.collectionCombo.setText(this.oldCollectionName);
        } else {
            this.collectionCombo.setText(EMPTY_STRING);
        }
        this.addCollectionComboListeners();
    }

    private void addCollectionComboListeners() {
        Listener[] selectionListeners;
        Listener[] modifyListeners = this.collectionCombo.getListeners(24);
        if (modifyListeners == null || modifyListeners.length == 0) {
            this.collectionCombo.addModifyListener(this.collectionModifyListener);
        }
        if ((selectionListeners = this.collectionCombo.getListeners(13)) == null || selectionListeners.length == 0) {
            this.collectionCombo.addSelectionListener(this.collectionSelectionListener);
        }
    }

    private void removeCollectionComboListeners() {
        Listener[] modifyListeners = this.collectionCombo.getListeners(24);
        int i = 0;
        while (i < modifyListeners.length) {
            this.collectionCombo.removeListener(24, modifyListeners[i]);
            ++i;
        }
        Listener[] selectionListeners = this.collectionCombo.getListeners(13);
        int i2 = 0;
        while (i2 < selectionListeners.length) {
            this.collectionCombo.removeListener(13, selectionListeners[i2]);
            ++i2;
        }
    }

    private void createCommandOpArea(Composite topArea) {
        this.commandOpArea = new Group(topArea, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 12;
        this.commandOpArea.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.commandOpArea.setLayoutData((Object)layoutData);
        this.commandOpArea.setText(Messages.getString("MongoDBDataSetWizardPage.group.text"));
        this.opTypeLabel = new Label((Composite)this.commandOpArea, 0);
        this.opTypeLabel.setText(Messages.getString("MongoDBDataSetWizardPage.label.OperationType"));
        this.opTypeCombo = new Combo((Composite)this.commandOpArea, 2056);
        this.opTypeCombo.setLayoutData((Object)new GridData(768));
        this.opTypeSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoDBDataSetWizardPage.this.opType != null && MongoDBDataSetWizardPage.this.opType.displayName().trim().equals(MongoDBDataSetWizardPage.this.opTypeCombo.getText().trim())) {
                    return;
                }
                MongoDBDataSetWizardPage.this.doOpTypeChanged();
                MongoDBDataSetWizardPage.this.handleCommandOperationSelection();
                if (MongoDBDataSetWizardPage.this.opTypeCombo.getText().trim().length() == 0 && MongoDBDataSetWizardPage.this.collectionCombo.getText().trim().length() > 0 && MessageDialog.open((int)3, (Shell)MongoDBDataSetWizardPage.this.getShell(), (String)Messages.getString("MongoDBDataSetWizardPage.MessageBox.title.PromptToRefreshAvailableFields"), (String)Messages.getString("MongoDBDataSetWizardPage.MessageBox.message.PromptToRefreshAvailableFields"), (int)0)) {
                    MongoDBDataSetWizardPage.this.doUpdateAvailableFieldsArea();
                }
                MongoDBDataSetWizardPage.this.modelChanged = true;
                MongoDBDataSetWizardPage.this.validateData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.opTypeCombo.addSelectionListener(this.opTypeSelectionListener);
        this.cmdExprBtn = new Button((Composite)this.commandOpArea, 8);
        this.cmdExprBtn.setText(Messages.getString("MongoDBDataSetWizardPage.Button.text.CommandExpression"));
        this.cmdExprBtn.setToolTipText(Messages.getString("MongoDBDataSetWizardPage.Button.tooltip.CommandExpression"));
        this.cmdExprBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MDBCommandExpressionBuilder cmdExprDialog = new MDBCommandExpressionBuilder(Display.getDefault().getActiveShell(), MongoDBDataSetWizardPage.this.opType);
                cmdExprDialog.setExpressionText(MongoDBDataSetWizardPage.this.cmdExprValue);
                if (cmdExprDialog.open() == 0) {
                    String oldCmdExpr = MongoDBDataSetWizardPage.this.cmdExprValue;
                    MongoDBDataSetWizardPage.this.cmdExprValue = cmdExprDialog.getExprText();
                    if (MongoDBDataSetWizardPage.this.cmdExprValue != null && !MongoDBDataSetWizardPage.this.cmdExprValue.equals(oldCmdExpr)) {
                        MongoDBDataSetWizardPage.this.modelChanged = true;
                        MongoDBDataSetWizardPage.this.queryProps.setOperationExpression(MongoDBDataSetWizardPage.this.cmdExprValue);
                        if (UIHelper.isEmptyString(MongoDBDataSetWizardPage.this.collectionName) && MongoDBDataSetWizardPage.this.allAvailableFields.size() == 0) {
                            MongoDBDataSetWizardPage.this.doUpdateAvailableFieldsArea();
                        } else if (MessageDialog.open((int)3, (Shell)MongoDBDataSetWizardPage.this.getShell(), (String)Messages.getString("MongoDBDataSetWizardPage.MessageBox.title.PromptToRefreshAvailableFields"), (String)Messages.getString("MongoDBDataSetWizardPage.MessageBox.message.PromptToRefreshAvailableFields"), (int)0)) {
                            MongoDBDataSetWizardPage.this.doUpdateAvailableFieldsArea();
                        }
                        MongoDBDataSetWizardPage.this.validateData();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void resetOpTypeComboItems() {
        String type;
        String string = type = this.opType == null ? EMPTY_STRING : this.opType.displayName();
        if (UIHelper.isEmptyString(this.collectionName)) {
            this.opTypeCombo.setItems(new String[]{EMPTY_STRING, QueryProperties.CommandOperationType.RUN_DB_COMMAND.displayName()});
        } else {
            this.opTypeCombo.setItems(new String[]{EMPTY_STRING, QueryProperties.CommandOperationType.AGGREGATE.displayName(), QueryProperties.CommandOperationType.MAP_REDUCE.displayName(), QueryProperties.CommandOperationType.RUN_DB_COMMAND.displayName()});
        }
        this.opTypeCombo.getItems();
        this.opTypeCombo.setText(type);
        this.doOpTypeChanged();
    }

    private void initPageInfos() throws OdaException {
        String value;
        String[] splits;
        this.dataSetDesign = this.getInitializationDesign();
        if (this.dataSetDesign == null) {
            return;
        }
        this.queryText = this.dataSetDesign.getQueryText();
        if (this.queryText == null) {
            return;
        }
        this.collectionList = new ArrayList<String>();
        this.selectedFields = new ArrayList<MDbMetaData.FieldMetaData>();
        this.allAvailableFields = new ArrayList<MDbMetaData.FieldMetaData>();
        this.queryProps = QueryProperties.deserialize((String)this.queryText);
        if (this.queryProps != null) {
            this.collectionName = this.queryProps.getCollectionName();
            this.cmdExprValue = this.queryProps.getOperationExpression();
            this.opType = this.queryProps.getOperationType();
            this.queryExpr = this.queryProps.getFindQueryExpr();
            this.sortExpr = this.queryProps.getSortExpr();
        }
        this.searchLimit = 1;
        this.includeSysColl = false;
        DesignerState odaState = this.getInitializationDesignerState();
        if (odaState != null && (splits = (value = odaState.getStateContent().getStateContentAsString()).split(DESIGNER_STATE_SEPARATOR)).length == 2) {
            this.includeSysColl = Boolean.parseBoolean(splits[0]);
            this.searchLimit = Integer.parseInt(splits[1]);
        }
        Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        this.metaData = new MDbMetaData(connProps);
        this.collectionList = this.metaData.getCollectionsList(!this.includeSysColl);
    }

    private void initializeSelectedFields() {
        if (this.queryProps == null) {
            return;
        }
        List selectedFieldNames = this.queryProps.getSelectedFieldNames();
        int i = 0;
        while (i < selectedFieldNames.size()) {
            String fieldName = (String)selectedFieldNames.get(i);
            if (!UIHelper.isEmptyString(fieldName)) {
                int j = 0;
                while (j < this.allAvailableFields.size()) {
                    if (fieldName.equals(this.allAvailableFields.get(j).getFullName())) {
                        this.selectedFields.add(this.allAvailableFields.get(j));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void initializeControl() {
        block9: {
            if (this.metaData != null && this.metaData.getDatabaseName() != null) {
                this.DBNameText.setText(this.metaData.getDatabaseName());
            }
            this.sysCollOption.setSelection(this.includeSysColl);
            this.removeCollectionComboListeners();
            this.opTypeCombo.removeSelectionListener(this.opTypeSelectionListener);
            this.resetCollectionComboItems();
            this.collectionCombo.setText(this.collectionName == null ? EMPTY_STRING : this.collectionName);
            this.resetOpTypeComboItems();
            this.opTypeCombo.setText(this.opType == null ? EMPTY_STRING : this.opType.displayName());
            this.handleCommandOperationSelection();
            this.resetOpTypeComboItems();
            this.docNumText.setText(String.valueOf(this.searchLimit));
            try {
                try {
                    if (QueryProperties.CommandOperationType.RUN_DB_COMMAND.name().equals(this.opType.name()) || !UIHelper.isEmptyString(this.collectionName)) {
                        this.updateAvailableFieldsList();
                    }
                }
                catch (OdaException ex) {
                    this.handleNoFieldsException((Exception)((Object)ex));
                    this.initializeSelectedFields();
                    this.refreshAvailableFieldsViewer();
                    this.refreshSelectedFieldsViewer();
                    this.availableFieldsViewer.getTree().setFocus();
                    this.availableFieldsViewer.expandToLevel(2);
                    this.updateButtons();
                    this.validateData();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.initializeSelectedFields();
                this.refreshAvailableFieldsViewer();
                this.refreshSelectedFieldsViewer();
                this.availableFieldsViewer.getTree().setFocus();
                this.availableFieldsViewer.expandToLevel(2);
                this.updateButtons();
                this.validateData();
                throw throwable;
            }
            this.initializeSelectedFields();
            this.refreshAvailableFieldsViewer();
            this.refreshSelectedFieldsViewer();
            this.availableFieldsViewer.getTree().setFocus();
            this.availableFieldsViewer.expandToLevel(2);
            this.updateButtons();
            this.validateData();
        }
        try {
            warningImage = UIHelper.getEmbeddedWarningImage();
        }
        catch (IOException e) {
            ExceptionHandler.showException((Shell)this.getShell(), (String)Messages.getString("MongoDBDataSetWizardPage.MessageDialog.title.GeneralError"), (String)e.getMessage(), (Throwable)e);
        }
        this.addCollectionComboListeners();
        this.opTypeCombo.addSelectionListener(this.opTypeSelectionListener);
    }

    private void refreshAvailableFieldsViewer() {
        if (this.metaData == null) {
            return;
        }
        if (QueryProperties.CommandOperationType.RUN_DB_COMMAND.name().equals(this.opType.name()) || !UIHelper.isEmptyString(this.collectionName)) {
            if (this.treeEntry == null) {
                this.treeEntry = new FieldEntryWrapper(this.collectionName, this.metaData, this.searchLimit, this.queryProps);
                this.availableFieldsViewer.setInput((Object)new FieldEntryWrapper[]{this.treeEntry});
            } else if (this.availableFieldsViewer.getInput() == null) {
                this.treeEntry.setCollectionName(this.collectionName);
                this.treeEntry.setMetaData(this.metaData);
                this.availableFieldsViewer.setInput((Object)new FieldEntryWrapper[]{this.treeEntry});
            } else {
                this.treeEntry.setCollectionName(this.collectionName);
                this.treeEntry.setMetaData(this.metaData);
                this.availableFieldsViewer.refresh();
            }
        }
    }

    private void refreshSelectedFieldsViewer() {
        this.selectedFieldsTable.setInput(this.selectedFields);
        this.selectedFieldsTable.refresh();
    }

    private void updateAvailableFieldsList() throws OdaException {
        this.allAvailableFields.clear();
        if (this.metaData == null) {
            throw new OdaException(Messages.getString("MongoDBDataSetWizardPage.ExceptionDialog.message.NoMetaData"));
        }
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (MongoDBDataSetWizardPage.this.treeEntry == null) {
                        MongoDBDataSetWizardPage.this.treeEntry = new FieldEntryWrapper(MongoDBDataSetWizardPage.this.collectionName, MongoDBDataSetWizardPage.this.metaData, MongoDBDataSetWizardPage.this.searchLimit, MongoDBDataSetWizardPage.this.queryProps);
                    } else {
                        MongoDBDataSetWizardPage.this.treeEntry.setCollectionName(MongoDBDataSetWizardPage.this.collectionName);
                        MongoDBDataSetWizardPage.this.treeEntry.setSearchLimit(MongoDBDataSetWizardPage.this.searchLimit);
                        MongoDBDataSetWizardPage.this.treeEntry.setQueryProps(MongoDBDataSetWizardPage.this.queryProps);
                    }
                    MongoDBDataSetWizardPage.this.treeEntry.updateAvailableFields();
                    MDbMetaData.DocumentsMetaData dmd = MongoDBDataSetWizardPage.this.treeEntry.getAvailableFields();
                    MongoDBDataSetWizardPage.this.addChildrenFieldsByDocument(dmd);
                }
                catch (Exception e) {
                    MongoDBDataSetWizardPage.this.handleNoFieldsException(e);
                }
            }
        });
    }

    private void addChildrenFieldsByDocument(MDbMetaData.DocumentsMetaData dmd) {
        if (dmd == null) {
            return;
        }
        for (String name : dmd.getFieldNames()) {
            MDbMetaData.FieldMetaData field = dmd.getFieldMetaData(name);
            this.allAvailableFields.add(field);
            if (!field.hasChildDocuments()) continue;
            this.addChildrenFieldsByDocument(field.getChildMetaData());
        }
    }

    private void updateButtons() {
        this.updateOperationButtons();
        this.updateMenuItems();
    }

    private void updateOperationButtons() {
        if (this.availableFieldsViewer.getTree().isFocusControl()) {
            if (this.availableFieldsViewer.getTree().getSelectionCount() > 0 && this.availableFieldsViewer.getTree().getSelection()[0].getData() instanceof FieldEntryWrapper) {
                this.addBtn.setEnabled(false);
            } else {
                this.addBtn.setEnabled(this.availableFieldsViewer.getTree().getSelectionCount() > 0 && !this.containsSelectedField(this.availableFieldsViewer.getTree().getSelection()));
            }
            this.addAllBtn.setEnabled(this.selectedFields.size() < this.allAvailableFields.size() && this.containsUnselectedItem(this.availableFieldsViewer.getTree().getSelection()));
            this.removeBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        } else if (this.selectedFieldsTable.getTable().isFocusControl()) {
            this.addBtn.setEnabled(false);
            this.addAllBtn.setEnabled(false);
            this.removeBtn.setEnabled(this.selectedFieldsTable.getTable().getSelectionCount() > 0);
            if (this.selectedFieldsTable.getTable().getSelectionCount() == 1) {
                int index = this.selectedFieldsTable.getTable().getSelectionIndex();
                int count = this.selectedFieldsTable.getTable().getItemCount();
                this.upBtn.setEnabled(index > 0 && index < count);
                this.downBtn.setEnabled(index >= 0 && index < count - 1);
            } else {
                this.upBtn.setEnabled(false);
                this.downBtn.setEnabled(false);
            }
        } else {
            this.addBtn.setEnabled(false);
            this.addAllBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        }
        this.removeAllBtn.setEnabled(this.selectedFields.size() > 0);
    }

    private void updateMenuItems() {
        if (this.selectedFieldsTable.getTable().getItemCount() == 0) {
            if (this.menu != null && !this.menu.isDisposed()) {
                this.menu.dispose();
                this.menuRemove.dispose();
                this.menuRemoveAll.dispose();
            }
        } else {
            this.createMenuItems();
            this.menuRemove.setEnabled(this.selectedFieldsTable.getTable().getSelection().length > 0);
            this.menuRemoveAll.setEnabled(this.selectedFieldsTable.getTable().getItemCount() > 0);
        }
    }

    private boolean containsSelectedField(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (this.isSelectedField(items[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSelectedField(TreeItem item) {
        if (item.getData() instanceof MDbMetaData.FieldMetaData) {
            return this.isSelectedField(((MDbMetaData.FieldMetaData)item.getData()).getFullDisplayName());
        }
        return false;
    }

    private boolean isSelectedField(String filedName) {
        int i = 0;
        while (i < this.selectedFields.size()) {
            if (filedName.equals(this.selectedFields.get(i).getFullDisplayName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsUnselectedItem(TreeItem[] items) {
        if (items.length > 0 && items[0].getData() instanceof FieldEntryWrapper) {
            return this.containsUnselectedItem(items[0].getItems(), true);
        }
        return this.containsUnselectedItem(items, false);
    }

    private boolean containsUnselectedItem(TreeItem[] items, boolean includeCurrent) {
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof MDbMetaData.FieldMetaData) {
                MDbMetaData.FieldMetaData field = (MDbMetaData.FieldMetaData)items[i].getData();
                if (includeCurrent ? (field.hasChildDocuments() ? !this.allChildrenSelected(field, false) : !this.isSelectedField(field.getFullDisplayName())) : field.hasChildDocuments() && !this.allChildrenSelected(field, includeCurrent)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean allChildrenSelected(MDbMetaData.FieldMetaData fieldMataData, boolean includeCurrent) {
        if (fieldMataData.hasChildDocuments()) {
            MDbMetaData.DocumentsMetaData dmd = fieldMataData.getChildMetaData();
            for (String name : dmd.getFieldNames()) {
                MDbMetaData.FieldMetaData field = dmd.getFieldMetaData(name);
                if (this.allChildrenSelected(field, false)) continue;
                return false;
            }
        }
        if (includeCurrent || !fieldMataData.hasChildDocuments()) {
            return this.isSelectedField(fieldMataData.getFullDisplayName());
        }
        return true;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.getControl() == null || !this.modelChanged) {
            return design;
        }
        if (this.hasValidData()) {
            this.savePage(design);
        }
        return design;
    }

    private boolean validateData() {
        boolean isValid = true;
        if (!QueryProperties.CommandOperationType.RUN_DB_COMMAND.name().equals(this.opType.name()) && UIHelper.isEmptyString(this.collectionName)) {
            isValid = false;
            this.setMessage(Messages.getString("MongoDBDataSetWizardPage.message.error.MissingCollectionName"), 3);
        } else if (!this.isNumber(this.docNumText.getText().trim())) {
            isValid = false;
            this.setMessage(Messages.getString("MongoDBDataSetWizardPage.message.error.InvalidDocumentNumber"), 3);
        } else if (!this.checkAllSelectedFields()) {
            isValid = false;
        } else if (!this.checkCommandExpression()) {
            isValid = false;
        } else if (this.selectedFields.size() == 0) {
            isValid = false;
            this.setMessage(Messages.getString("MongoDBDataSetWizardPage.message.error.MissingSelectedField"), 3);
        }
        if (isValid) {
            this.setMessage(DEFAULT_MESSAGE);
        }
        this.setPageComplete(isValid);
        return isValid;
    }

    private boolean hasValidData() {
        this.validateData();
        return this.canLeave();
    }

    private void savePage(DataSetDesign design) {
        MongoDBDriver driver = new MongoDBDriver();
        IConnection customConn = null;
        try {
            try {
                customConn = driver.getConnection(null);
                Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                customConn.open(connProps);
                this.updateDesign(design, customConn);
            }
            catch (Exception e) {
                this.handleNoFieldsException(e);
                this.closeConnection(customConn);
            }
        }
        finally {
            this.closeConnection(customConn);
        }
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn) throws OdaException {
        this.queryProps.setSelectedFields(this.selectedFields);
        this.queryProps.setCollectionName(this.collectionName);
        DesignFactory factory = DesignFactory.eINSTANCE;
        DesignerState odaState = factory.createDesignerState();
        DesignerStateContent content = factory.createDesignerStateContent();
        String value = String.valueOf(String.valueOf(this.includeSysColl)) + DESIGNER_STATE_SEPARATOR + String.valueOf(this.searchLimit);
        content.setStateContentAsString(value);
        odaState.setStateContent(content);
        odaState.setVersion("1.0");
        this.setResponseDesignerState(odaState);
        String queryPropsText = this.queryProps.serialize();
        dataSetDesign.setQueryText(queryPropsText);
        MDbQuery query = (MDbQuery)conn.newQuery("org.eclipse.birt.data.oda.mongodb.dataSet");
        query.prepare(queryPropsText);
        try {
            query.setMetaDataSearchLimit(this.searchLimit);
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            String errorMsg = UIHelper.getUserErrorMessage("MongoDBDataSetWizardPage.ExceptionDialog.message.SavaPage", (Exception)((Object)e));
            ExceptionHandler.showException((Shell)this.sComposite.getShell(), (String)Messages.getString("MongoDBDataSetWizardPage.ExceptionDialog.title"), (String)errorMsg, (Throwable)e);
            this.setPageComplete(false);
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    protected boolean canLeave() {
        int exprType = 1;
        try {
            if (this.opType != QueryProperties.CommandOperationType.DYNAMIC_QUERY) {
                exprType = 1;
                QueryModel.validateCommandSyntax((QueryProperties.CommandOperationType)this.opType, (String)this.cmdExprValue);
            }
            if (this.opType == QueryProperties.CommandOperationType.DYNAMIC_QUERY || this.opType == QueryProperties.CommandOperationType.MAP_REDUCE) {
                if (!UIHelper.isEmptyString(this.queryExpr)) {
                    exprType = 2;
                    QueryModel.validateQuerySyntax((String)this.queryExpr);
                }
                if (!UIHelper.isEmptyString(this.sortExpr)) {
                    exprType = 3;
                    QueryModel.validateSortExprSyntax((String)this.sortExpr);
                }
            }
        }
        catch (OdaException e) {
            String usrMsgKey = null;
            switch (exprType) {
                case 1: {
                    usrMsgKey = "MongoDBDataSetWizardPage.ExceptionDialog.message.InvalidCommandExpression";
                    break;
                }
                case 2: {
                    usrMsgKey = "MongoDBDataSetWizardPage.ExceptionDialog.message.InvalidQueryExpression";
                    break;
                }
                case 3: {
                    usrMsgKey = "MongoDBDataSetWizardPage.ExceptionDialog.message.InvalidSortExpression";
                }
            }
            String errorMsg = UIHelper.getUserErrorMessage(usrMsgKey, (Exception)((Object)e));
            ExceptionHandler.showException((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("MongoDBDataSetWizardPage.ExceptionDialog.title"), (String)errorMsg, (Throwable)e);
            this.setMessage(Messages.getString(usrMsgKey), 3);
            this.setPageComplete(false);
            return false;
        }
        return this.isPageComplete();
    }

    private boolean isNumber(String text) {
        if (UIHelper.isEmptyString(text)) {
            return false;
        }
        return text.matches("^[0-9]*[1-9][0-9]*$");
    }

    private boolean existsField(MDbMetaData.FieldMetaData field) {
        if (field == null) {
            return false;
        }
        int i = 0;
        while (i < this.allAvailableFields.size()) {
            if (field.equals(this.allAvailableFields.get(i)) || field.getFullDisplayName().equals(this.allAvailableFields.get(i).getFullDisplayName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkAllSelectedFields() {
        int i = 0;
        while (i < this.selectedFields.size()) {
            if (!this.existsField(this.selectedFields.get(i))) {
                this.setMessage(Messages.getFormattedString("MongoDBDataSetWizardPage.message.error.SelectedFieldNotFound", new Object[]{this.selectedFields.get(i).getFullDisplayName()}), 3);
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkCommandExpression() {
        if (this.opType.displayName().trim().length() > 0 && (this.cmdExprValue == null || this.cmdExprValue.trim().length() == 0)) {
            this.setMessage(Messages.getString("MongoDBDataSetWizardPage.message.error.MissingCommandExpression"), 3);
            return false;
        }
        return true;
    }

    private void handleCommandOperationSelection() {
        this.cmdExprBtn.setEnabled(this.opType.displayName().trim().length() > 0);
        boolean collectionAreaEnabled = this.opType == null || !QueryProperties.CommandOperationType.RUN_DB_COMMAND.name().equals(this.opType.name());
        this.sysCollOption.setEnabled(collectionAreaEnabled);
        this.refreshBtn.setEnabled(collectionAreaEnabled);
        this.resetExprBtnStatus();
        if (this.collectionCombo.getEnabled() != collectionAreaEnabled) {
            this.collectionCombo.setEnabled(collectionAreaEnabled);
            if (collectionAreaEnabled) {
                this.collectionCombo.setText(this.oldCollectionName);
            } else {
                this.oldCollectionName = this.collectionName;
                this.collectionName = EMPTY_STRING;
            }
        }
    }

    private void resetExprBtnStatus() {
        boolean queryExprBtnEnabled;
        boolean sortExprBtnEnabled = queryExprBtnEnabled = !QueryProperties.CommandOperationType.AGGREGATE.name().equals(this.opType.name()) && !QueryProperties.CommandOperationType.RUN_DB_COMMAND.name().equals(this.opType.name());
        this.queryExprBtn.setEnabled(queryExprBtnEnabled);
        this.sortExprBtn.setEnabled(sortExprBtnEnabled);
    }

    private void deselectAll() {
        this.availableFieldsViewer.getTree().deselectAll();
        this.selectedFieldsTable.getTable().deselectAll();
    }

    private void autoSelectRootItem() {
        this.availableFieldsViewer.getTree().setFocus();
        if (this.availableFieldsViewer.getTree().getTopItem() != null) {
            this.availableFieldsViewer.getTree().select(this.availableFieldsViewer.getTree().getTopItem());
        }
        this.updateButtons();
    }

    private void doUpdateAvailableFieldsArea() {
        try {
            this.updateAvailableFieldsList();
            this.refreshAvailableFieldsViewer();
            this.availableFieldsViewer.expandToLevel(2);
            this.refreshSelectedFieldsViewer();
            this.autoSelectRootItem();
        }
        catch (OdaException odaException) {
            this.availableFieldsViewer.refresh();
            this.refreshSelectedFieldsViewer();
        }
    }

    private void handleNoFieldsException(final Exception e) {
        if (!this.flag) {
            this.flag = true;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String errorMsg = UIHelper.getUserErrorMessage("MongoDBDataSetWizardPage.ExceptionDialog.message.FindFields", e);
                    ExceptionHandler.showException((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("MongoDBDataSetWizardPage.ExceptionDialog.title"), (String)errorMsg, (Throwable)e);
                    MongoDBDataSetWizardPage.this.flag = false;
                }
            });
        }
    }

    private void doOpTypeChanged() {
        this.opType = QueryProperties.CommandOperationType.getType((String)this.opTypeCombo.getText().trim());
        this.queryProps.setOperationType(this.opType);
    }

    private void doRemoveSelectedFields() {
        int[] indices = this.selectedFieldsTable.getTable().getSelectionIndices();
        if (indices.length == 0) {
            return;
        }
        int lastIndex = indices[indices.length - 1];
        int focusIndex = lastIndex - indices.length + 1;
        this.doRemoveSelectedFields(this.selectedFieldsTable.getTable().getSelection());
        this.availableFieldsViewer.refresh();
        this.selectedFieldsTable.refresh();
        this.deselectAll();
        int tableFieldsCount = this.selectedFieldsTable.getTable().getItemCount();
        if (tableFieldsCount > 0) {
            this.selectedFieldsTable.getTable().setFocus();
            if (focusIndex < 0) {
                this.selectedFieldsTable.getTable().setSelection(0);
            } else if (focusIndex >= tableFieldsCount) {
                this.selectedFieldsTable.getTable().setSelection(tableFieldsCount - 1);
            } else {
                this.selectedFieldsTable.getTable().setSelection(focusIndex);
            }
        }
        this.updateButtons();
        this.validateData();
        this.modelChanged = true;
    }

    private class FieldsTreeProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private FieldsTreeProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof FieldEntryWrapper) {
                return true;
            }
            if (element instanceof Object[]) {
                return ((Object[])element).length > 0;
            }
            if (element instanceof MDbMetaData.FieldMetaData) {
                return ((MDbMetaData.FieldMetaData)element).hasChildDocuments();
            }
            return false;
        }

        public Image getImage(Object element) {
            try {
                if (element instanceof FieldEntryWrapper) {
                    if (QueryProperties.CommandOperationType.RUN_DB_COMMAND.name().equals(MongoDBDataSetWizardPage.this.opType.name()) || UIHelper.isEmptyString(MongoDBDataSetWizardPage.this.collectionName)) {
                        return UIHelper.getDatabaseDisplayImage();
                    }
                    return UIHelper.getCollectionDisplayImage();
                }
                if (element instanceof MDbMetaData.FieldMetaData) {
                    MDbMetaData.FieldMetaData fieldMetaData = (MDbMetaData.FieldMetaData)element;
                    if (fieldMetaData.hasChildDocuments()) {
                        if (MongoDBDataSetWizardPage.this.isSelectedField(fieldMetaData.getFullDisplayName())) {
                            return UIHelper.getSelectedDocumentDisplayImage();
                        }
                        return UIHelper.getDocumentDisplayImage();
                    }
                    if (MongoDBDataSetWizardPage.this.isSelectedField(fieldMetaData.getFullDisplayName())) {
                        return UIHelper.getSelectedFieldDisplayImage();
                    }
                    return UIHelper.getFieldDisplayImage();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FieldEntryWrapper) {
                if (QueryProperties.CommandOperationType.RUN_DB_COMMAND.name().equals(MongoDBDataSetWizardPage.this.opType.name()) || UIHelper.isEmptyString(MongoDBDataSetWizardPage.this.collectionName)) {
                    return MongoDBDataSetWizardPage.this.metaData.getDatabaseName();
                }
                return ((FieldEntryWrapper)element).getCollectionName();
            }
            if (element instanceof MDbMetaData.FieldMetaData) {
                return ((MDbMetaData.FieldMetaData)element).getSimpleDisplayName();
            }
            return element == null ? MongoDBDataSetWizardPage.EMPTY_STRING : element.toString();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof FieldEntryWrapper[]) {
                return (FieldEntryWrapper[])inputElement;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof FieldEntryWrapper) {
                try {
                    MDbMetaData.DocumentsMetaData dmd = ((FieldEntryWrapper)parentElement).getAvailableFields();
                    return this.getFields(dmd);
                }
                catch (OdaException e) {
                    MongoDBDataSetWizardPage.this.handleNoFieldsException((Exception)((Object)e));
                    return new String[0];
                }
            }
            if (parentElement instanceof MDbMetaData.DocumentsMetaData) {
                return this.getFields(parentElement);
            }
            if (parentElement instanceof MDbMetaData.FieldMetaData) {
                return this.getFields(((MDbMetaData.FieldMetaData)parentElement).getChildMetaData());
            }
            return new String[0];
        }

        private Object[] getFields(Object parentElement) {
            ArrayList<MDbMetaData.FieldMetaData> entries = new ArrayList<MDbMetaData.FieldMetaData>();
            for (String name : ((MDbMetaData.DocumentsMetaData)parentElement).getFieldNames()) {
                entries.add(((MDbMetaData.DocumentsMetaData)parentElement).getFieldMetaData(name));
            }
            return entries.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }
    }

    private class TableProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private TableProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                try {
                    if (element instanceof MDbMetaData.FieldMetaData && !MongoDBDataSetWizardPage.this.existsField((MDbMetaData.FieldMetaData)element)) {
                        return UIHelper.getEmbeddedWarningImage();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                if (element instanceof MDbMetaData.FieldMetaData) {
                    return ((MDbMetaData.FieldMetaData)element).getFullDisplayName();
                }
                return element.toString();
            }
            return null;
        }
    }
}

