/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import net.sourceforge.nattable.command.DisposeResourcesCommand;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.config.ConfigRegistry;
import net.sourceforge.nattable.config.DefaultNatTableStyleConfiguration;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.config.IConfiguration;
import net.sourceforge.nattable.conflation.EventConflaterChain;
import net.sourceforge.nattable.conflation.VisualChangeEventConflater;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.edit.ActiveCellEditor;
import net.sourceforge.nattable.edit.InlineCellEditController;
import net.sourceforge.nattable.grid.command.ClientAreaResizeCommand;
import net.sourceforge.nattable.grid.command.InitializeGridCommand;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.ILayerListener;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.layer.event.IVisualChangeEvent;
import net.sourceforge.nattable.layer.stack.DummyGridLayerStack;
import net.sourceforge.nattable.painter.IOverlayPainter;
import net.sourceforge.nattable.painter.layer.ILayerPainter;
import net.sourceforge.nattable.persistence.IPersistable;
import net.sourceforge.nattable.ui.binding.UiBindingRegistry;
import net.sourceforge.nattable.ui.mode.ConfigurableModeEventHandler;
import net.sourceforge.nattable.ui.mode.ModeSupport;
import net.sourceforge.nattable.util.GUIHelper;
import net.sourceforge.nattable.util.IClientAreaProvider;
import net.sourceforge.nattable.viewport.command.RecalculateScrollBarsCommand;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTable
extends Canvas
implements ILayer,
PaintListener,
IClientAreaProvider,
ILayerListener,
IPersistable {
    public static final int DEFAULT_STYLE_OPTIONS = 538182400;
    private UiBindingRegistry uiBindingRegistry;
    private ModeSupport modeSupport;
    private final EventConflaterChain conflaterChain = new EventConflaterChain();
    private final List<IOverlayPainter> overlayPainters = new ArrayList<IOverlayPainter>();
    private final List<IPersistable> persistables = new LinkedList<IPersistable>();
    private ILayer underlyingLayer;
    private IConfigRegistry configRegistry;
    private final Collection<IConfiguration> configurations = new LinkedList<IConfiguration>();
    protected String id = GUIHelper.getSequenceNumber();
    private ILayerPainter layerPainter = new NatLayerPainter();
    private final boolean autoconfigure;
    private final List<ILayerListener> listeners = new ArrayList<ILayerListener>();

    public NatTable(Composite parent) {
        this(parent, 538182400);
    }

    public NatTable(Composite parent, boolean autoconfigure) {
        this(parent, 538182400, autoconfigure);
    }

    public NatTable(Composite parent, ILayer layer) {
        this(parent, 538182400, layer);
    }

    public NatTable(Composite parent, ILayer layer, boolean autoconfigure) {
        this(parent, 538182400, layer, autoconfigure);
    }

    public NatTable(Composite parent, int style) {
        this(parent, style, new DummyGridLayerStack());
    }

    public NatTable(Composite parent, int style, boolean autoconfigure) {
        this(parent, style, new DummyGridLayerStack(), autoconfigure);
    }

    public NatTable(Composite parent, int style, ILayer layer) {
        this(parent, style, layer, true);
    }

    public NatTable(Composite parent, int style, ILayer layer, boolean autoconfigure) {
        super(parent, style);
        this.disableScrollBar(this.getHorizontalBar());
        this.disableScrollBar(this.getVerticalBar());
        this.initInternalListener();
        this.internalSetLayer(layer);
        this.autoconfigure = autoconfigure;
        if (autoconfigure) {
            this.configurations.add(new DefaultNatTableStyleConfiguration());
            this.configure();
        }
        this.conflaterChain.add(new VisualChangeEventConflater(this));
        this.conflaterChain.start();
    }

    public void dispose() {
        this.doCommand(new DisposeResourcesCommand());
        this.conflaterChain.stop();
        InlineCellEditController.dispose();
        ActiveCellEditor.close();
        super.dispose();
    }

    private void disableScrollBar(ScrollBar scrollBar) {
        scrollBar.setMinimum(0);
        scrollBar.setMaximum(1);
        scrollBar.setThumb(1);
        scrollBar.setEnabled(false);
    }

    public ILayer getLayer() {
        return this.underlyingLayer;
    }

    public void setLayer(ILayer layer) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set layer post construction if autoconfigure is turned off");
        }
        this.internalSetLayer(layer);
    }

    private void internalSetLayer(ILayer layer) {
        if (layer != null) {
            this.underlyingLayer = layer;
            this.underlyingLayer.setClientAreaProvider(new IClientAreaProvider(){

                public Rectangle getClientArea() {
                    if (!NatTable.this.isDisposed()) {
                        return NatTable.this.getClientArea();
                    }
                    return new Rectangle(0, 0, 0, 0);
                }
            });
            this.underlyingLayer.addLayerListener(this);
        }
    }

    public void addConfiguration(IConfiguration configuration) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only add configurations post construction if autoconfigure is turned off");
        }
        this.configurations.add(configuration);
    }

    public IConfigRegistry getConfigRegistry() {
        if (this.configRegistry == null) {
            this.configRegistry = new ConfigRegistry();
        }
        return this.configRegistry;
    }

    public void setConfigRegistry(IConfigRegistry configRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set config registry post construction if autoconfigure is turned off");
        }
        this.configRegistry = configRegistry;
    }

    public UiBindingRegistry getUiBindingRegistry() {
        if (this.uiBindingRegistry == null) {
            this.uiBindingRegistry = new UiBindingRegistry(this);
        }
        return this.uiBindingRegistry;
    }

    public void setUiBindingRegistry(UiBindingRegistry uiBindingRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set UI binding registry post construction if autoconfigure is turned off");
        }
        this.uiBindingRegistry = uiBindingRegistry;
    }

    public String getID() {
        return this.id;
    }

    protected void checkSubclass() {
    }

    protected void initInternalListener() {
        this.modeSupport = new ModeSupport(this);
        this.modeSupport.registerModeEventHandler("NORMAL_MODE", new ConfigurableModeEventHandler(this.modeSupport, this));
        this.modeSupport.switchMode("NORMAL_MODE");
        this.addPaintListener(this);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                NatTable.this.redraw();
            }

            public void focusGained(FocusEvent arg0) {
                NatTable.this.redraw();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                NatTable.this.doCommand(new ClientAreaResizeCommand((Scrollable)NatTable.this));
            }
        });
    }

    public boolean forceFocus() {
        return super.forceFocus();
    }

    public void addOverlayPainter(IOverlayPainter overlayPainter) {
        this.overlayPainters.add(overlayPainter);
    }

    public void removeOverlayPainter(IOverlayPainter overlayPainter) {
        this.overlayPainters.remove(overlayPainter);
    }

    public void paintControl(PaintEvent event) {
        this.paintNatTable(event);
    }

    private void paintNatTable(PaintEvent event) {
        this.getLayerPainter().paintLayer(this, event.gc, 0, 0, new Rectangle(event.x, event.y, event.width, event.height), this.getConfigRegistry());
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public void setLayerPainter(ILayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    public void repaintColumn(int columnPosition) {
        this.redraw(this.getStartXOfColumnPosition(columnPosition), 0, this.getColumnWidthByPosition(columnPosition), this.getHeight(), true);
    }

    public void repaintRow(int rowPosition) {
        this.redraw(0, this.getStartYOfRowPosition(rowPosition), this.getWidth(), this.getRowHeightByPosition(rowPosition), true);
    }

    public void updateResize() {
        this.updateResize(true);
    }

    private void updateResize(boolean redraw) {
        if (this.isDisposed()) {
            return;
        }
        this.doCommand(new RecalculateScrollBarsCommand());
        if (redraw) {
            this.redraw();
        }
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        throw new UnsupportedOperationException("Cannot use this method to configure NatTable. Use no-argument configure() instead.");
    }

    public void configure() {
        if (this.underlyingLayer == null) {
            throw new IllegalStateException("Layer must be set before configure is called");
        }
        if (this.underlyingLayer != null) {
            this.underlyingLayer.configure((ConfigRegistry)this.getConfigRegistry(), this.uiBindingRegistry);
        }
        for (IConfiguration configuration : this.configurations) {
            configuration.configureLayer(this);
            configuration.configureRegistry(this.getConfigRegistry());
            configuration.configureUiBindings(this.uiBindingRegistry);
        }
        this.doCommand(new InitializeGridCommand((Composite)this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        for (ILayerListener layerListener : this.listeners) {
            layerListener.handleLayerEvent(event);
        }
        if (event instanceof IVisualChangeEvent) {
            this.conflaterChain.addEvent(event);
        }
    }

    protected Rectangle getPixelRectangleFromPositionRectangle(Rectangle positionRectangle) {
        int positionRectWidthInPixels = 0;
        int positionRectHeightInPixels = 0;
        Rectangle pixelRectangle = new Rectangle(0, 0, 0, 0);
        int i = positionRectangle.x;
        while (i < positionRectangle.x + positionRectangle.width) {
            positionRectWidthInPixels += this.getColumnWidthByPosition(i);
            ++i;
        }
        i = positionRectangle.y;
        while (i < positionRectangle.y + positionRectangle.height) {
            positionRectHeightInPixels += this.getRowHeightByPosition(i);
            ++i;
        }
        pixelRectangle.x = this.getStartXOfColumnPosition(positionRectangle.x);
        pixelRectangle.y = this.getStartYOfRowPosition(positionRectangle.y);
        pixelRectangle.width = positionRectWidthInPixels;
        pixelRectangle.height = positionRectHeightInPixels;
        return pixelRectangle;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        this.underlyingLayer.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.underlyingLayer.loadState(prefix, properties);
    }

    @Override
    public void registerPersistable(IPersistable persistable) {
        this.persistables.add(persistable);
    }

    @Override
    public void unregisterPersistable(IPersistable persistable) {
        this.persistables.remove(persistable);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        return this.underlyingLayer.doCommand(command);
    }

    @Override
    public void fireLayerEvent(ILayerEvent event) {
        this.underlyingLayer.fireLayerEvent(event);
    }

    @Override
    public void addLayerListener(ILayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLayerListener(ILayerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getColumnCount() {
        return this.underlyingLayer.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.underlyingLayer.getPreferredColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        return this.underlyingLayer.getColumnIndexByPosition(columnPosition);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return localColumnPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return -1;
        }
        return underlyingColumnPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return null;
        }
        return underlyingColumnPositionRanges;
    }

    @Override
    public int getWidth() {
        return this.underlyingLayer.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.underlyingLayer.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.underlyingLayer.getColumnWidthByPosition(columnPosition);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.underlyingLayer.isColumnPositionResizable(columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.underlyingLayer.getColumnPositionByX(x);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.underlyingLayer.getStartXOfColumnPosition(columnPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.underlyingLayer);
        return underlyingLayers;
    }

    @Override
    public int getRowCount() {
        return this.underlyingLayer.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.underlyingLayer.getPreferredRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        return this.underlyingLayer.getRowIndexByPosition(rowPosition);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        return localRowPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return -1;
        }
        return underlyingRowPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return null;
        }
        return underlyingRowPositionRanges;
    }

    @Override
    public int getHeight() {
        return this.underlyingLayer.getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.underlyingLayer.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return this.underlyingLayer.getRowHeightByPosition(rowPosition);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        return this.underlyingLayer.isRowPositionResizable(rowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return this.underlyingLayer.getRowPositionByY(y);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.underlyingLayer.getStartYOfRowPosition(rowPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.underlyingLayer);
        return underlyingLayers;
    }

    @Override
    public LayerCell getCellByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getCellByPosition(columnPosition, rowPosition);
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getBoundsByPosition(columnPosition, rowPosition);
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getDataValueByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        return this.underlyingLayer.getRegionLabelsByXY(x, y);
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer;
    }

    @Override
    public IClientAreaProvider getClientAreaProvider() {
        return this;
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        throw new UnsupportedOperationException("Cannot set an area provider.");
    }

    public class NatLayerPainter
    implements ILayerPainter {
        public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
            try {
                gc.setForeground(NatTable.this.getForeground());
                gc.setBackground(NatTable.this.getBackground());
                gc.fillRectangle(rectangle);
                ILayerPainter layerPainter = NatTable.this.underlyingLayer.getLayerPainter();
                layerPainter.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
                for (IOverlayPainter overlayPainter : NatTable.this.overlayPainters) {
                    overlayPainter.paintOverlay(gc, NatTable.this);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.err.println("Error while painting table: " + e.getMessage());
            }
        }

        public Rectangle adjustCellBounds(Rectangle cellBounds) {
            ILayerPainter layerPainter = NatTable.this.underlyingLayer.getLayerPainter();
            return layerPainter.adjustCellBounds(cellBounds);
        }
    }
}

