/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.BlockIoStats;
import com.spotify.docker.client.messages.CpuStats;
import com.spotify.docker.client.messages.MemoryStats;
import com.spotify.docker.client.messages.NetworkStats;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerStats {
    @JsonProperty(value="read")
    private Date read;
    @JsonProperty(value="network")
    private NetworkStats network;
    @JsonProperty(value="networks")
    private ImmutableMap<String, NetworkStats> networks;
    @JsonProperty(value="memory_stats")
    private MemoryStats memoryStats;
    @JsonProperty(value="blkio_stats")
    private BlockIoStats blockIoStats;
    @JsonProperty(value="cpu_stats")
    private CpuStats cpuStats;
    @JsonProperty(value="precpu_stats")
    private CpuStats precpuStats;

    public Date read() {
        return new Date(this.read.getTime());
    }

    public NetworkStats network() {
        return this.network;
    }

    public Map<String, NetworkStats> networks() {
        return this.networks;
    }

    public MemoryStats memoryStats() {
        return this.memoryStats;
    }

    public BlockIoStats blockIoStats() {
        return this.blockIoStats;
    }

    public CpuStats cpuStats() {
        return this.cpuStats;
    }

    public CpuStats precpuStats() {
        return this.precpuStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerStats that = (ContainerStats)o;
        return Objects.equals(this.read, that.read) && Objects.equals(this.network, that.network) && Objects.equals(this.networks, that.networks) && Objects.equals(this.memoryStats, that.memoryStats) && Objects.equals(this.blockIoStats, that.blockIoStats) && Objects.equals(this.cpuStats, that.cpuStats) && Objects.equals(this.precpuStats, that.precpuStats);
    }

    public int hashCode() {
        return Objects.hash(this.cpuStats, this.memoryStats, this.network, this.networks, this.blockIoStats, this.precpuStats, this.read);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpuStats", (Object)this.cpuStats).add("memoryStats", (Object)this.memoryStats).add("network", (Object)this.network).add("networks", this.networks).add("blkioStats", (Object)this.blockIoStats).add("precpuStats", (Object)this.precpuStats).add("read", (Object)this.read).toString();
    }
}

