/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.Notation;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class NotationSection
extends AbstractSection {
    private final String PUBLIC_ID = DTDPropertiesMessages._UI_LABEL_PUBLIC_ID;
    private final String SYSTEM_ID = DTDPropertiesMessages._UI_LABEL_SYSTEM_ID;
    private Text publicIdText;
    private Text systemIdText;
    private CLabel publicIdLabel;
    private CLabel systemIdLabel;

    public void doHandleEvent(Event event) {
        if (event.widget == this.publicIdText) {
            Object input = this.getInput();
            String newValue = this.publicIdText.getText();
            if (input instanceof Notation) {
                Notation notation = (Notation)input;
                notation.setPublicID(newValue);
            }
        } else if (event.widget == this.systemIdText) {
            Object input = this.getInput();
            String newValue = this.systemIdText.getText();
            if (input instanceof Notation) {
                Notation notation = (Notation)input;
                notation.setSystemID(newValue);
            }
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.publicIdLabel = this.getWidgetFactory().createCLabel(composite, this.PUBLIC_ID);
        Point p = this.publicIdLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.publicIdLabel.setLayoutData((Object)data);
        this.publicIdText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)this.publicIdLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.publicIdLabel, 0, 0x1000000);
        this.publicIdText.setLayoutData((Object)data);
        this.publicIdText.addListener(24, (Listener)this);
        this.systemIdLabel = this.getWidgetFactory().createCLabel(composite, this.SYSTEM_ID);
        p = this.systemIdLabel.computeSize(-1, -1, false);
        labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.publicIdLabel, 4);
        this.systemIdLabel.setLayoutData((Object)data);
        this.systemIdText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)this.systemIdLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.systemIdLabel, 0, 0x1000000);
        this.systemIdText.setLayoutData((Object)data);
        this.systemIdText.addListener(24, (Listener)this);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        this.publicIdText.setText("");
        this.systemIdText.setText("");
        if (input != null && input instanceof Notation) {
            Notation notation = (Notation)input;
            this.publicIdText.setText(notation.getPublicID());
            this.systemIdText.setText(notation.getSystemID());
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }
}

