/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRoot;

public class WorkbenchComponentImpl
extends EObjectImpl
implements WorkbenchComponent {
    protected static final String NAME_EDEFAULT = "";
    protected String name = "";
    protected EList resources = null;
    protected ComponentType componentType = null;
    protected EList referencedComponents = null;
    protected EList properties = null;
    protected EList metadataResources = null;
    private URI handle;
    private IPath defaultSourceRoot;

    protected WorkbenchComponentImpl() {
    }

    private IPath getFirstRootSource() {
        EList res = this.getResources();
        for (ComponentResource element : res) {
            if (!element.getRuntimePath().equals((Object)new Path("/"))) continue;
            return element.getSourcePath();
        }
        return null;
    }

    private IPath getFirstTaggedRootSource() {
        EList res = this.getResources();
        for (ComponentResource element : res) {
            if (!element.getRuntimePath().equals((Object)new Path("/")) || !"defaultRootSource".equals(element.getTag())) continue;
            return element.getSourcePath();
        }
        return null;
    }

    protected EClass eStaticClass() {
        return ComponentcorePackage.eINSTANCE.getWorkbenchComponent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setNameGen(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public void setName(String newDeployedName) {
        URI resourceURI;
        this.setNameGen(newDeployedName);
        if (this.eResource() != null && (resourceURI = this.eResource().getURI()) != null && resourceURI.segmentCount() >= 2) {
            this.setHandle(this.computeHandle());
        }
    }

    protected void setHandle(URI aHandle) {
        this.handle = aHandle;
    }

    @Override
    public URI getHandle() {
        if (this.handle == null) {
            this.handle = this.computeHandle();
        }
        return this.handle;
    }

    private URI computeHandle() {
        return URI.createURI((String)("module:/resource/" + this.computeProjectName() + '/' + this.getName()));
    }

    private String computeProjectName() {
        IProject project = ProjectUtilities.getProject((EObject)this);
        return project != null ? project.getName() : "UNCONTAINED";
    }

    @Override
    public EList getResources() {
        if (this.resources == null) {
            this.resources = new EObjectContainmentWithInverseEList(ComponentResource.class, (InternalEObject)this, 1, 3);
        }
        return this.resources;
    }

    @Override
    public ComponentType getComponentType() {
        return this.componentType;
    }

    public NotificationChain basicSetComponentType(ComponentType newComponentType, NotificationChain msgs) {
        ComponentType oldComponentType = this.componentType;
        this.componentType = newComponentType;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldComponentType, (Object)newComponentType);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setComponentType(ComponentType newComponentType) {
        if (newComponentType != this.componentType) {
            NotificationChain msgs = null;
            if (this.componentType != null) {
                msgs = ((InternalEObject)this.componentType).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newComponentType != null) {
                msgs = ((InternalEObject)newComponentType).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetComponentType(newComponentType, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newComponentType, (Object)newComponentType));
        }
    }

    @Override
    public EList getReferencedComponents() {
        if (this.referencedComponents == null) {
            this.referencedComponents = new EObjectContainmentEList(ReferencedComponent.class, (InternalEObject)this, 3);
        }
        return this.referencedComponents;
    }

    @Override
    public EList getProperties() {
        if (this.properties == null) {
            this.properties = new EObjectResolvingEList(Property.class, (InternalEObject)this, 4);
        }
        return this.properties;
    }

    @Override
    public EList getMetadataResources() {
        if (this.metadataResources == null) {
            this.metadataResources = new EDataTypeUniqueEList(IPath.class, (InternalEObject)this, 5);
        }
        return this.metadataResources;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 1: {
                    return ((InternalEList)this.getResources()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 1: {
                    return ((InternalEList)this.getResources()).basicRemove((Object)otherEnd, msgs);
                }
                case 2: {
                    return this.basicSetComponentType(null, msgs);
                }
                case 3: {
                    return ((InternalEList)this.getReferencedComponents()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getResources();
            }
            case 2: {
                return this.getComponentType();
            }
            case 3: {
                return this.getReferencedComponents();
            }
            case 4: {
                return this.getProperties();
            }
            case 5: {
                return this.getMetadataResources();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.getResources().clear();
                this.getResources().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setComponentType((ComponentType)newValue);
                return;
            }
            case 3: {
                this.getReferencedComponents().clear();
                this.getReferencedComponents().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getMetadataResources().clear();
                this.getMetadataResources().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.getResources().clear();
                return;
            }
            case 2: {
                this.setComponentType(null);
                return;
            }
            case 3: {
                this.getReferencedComponents().clear();
                return;
            }
            case 4: {
                this.getProperties().clear();
                return;
            }
            case 5: {
                this.getMetadataResources().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return this.resources != null && !this.resources.isEmpty();
            }
            case 2: {
                return this.componentType != null;
            }
            case 3: {
                return this.referencedComponents != null && !this.referencedComponents.isEmpty();
            }
            case 4: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 5: {
                return this.metadataResources != null && !this.metadataResources.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", metadataResources: ");
        result.append(this.metadataResources);
        result.append(')');
        return result.toString();
    }

    @Override
    public ComponentResource[] findResourcesByRuntimePath(IPath aDeployPath) {
        ResourceTreeRoot resourceTreeRoot = ResourceTreeRoot.getDeployResourceTreeRoot(this);
        return resourceTreeRoot.findModuleResources(aDeployPath, 0);
    }

    @Override
    public ComponentResource[] findResourcesBySourcePath(IPath aSourcePath, int resourceFlag) {
        ResourceTreeRoot resourceTreeRoot = ResourceTreeRoot.getSourceResourceTreeRoot(this);
        return resourceTreeRoot.findModuleResources(aSourcePath, resourceFlag);
    }

    @Override
    public boolean exists(IPath aSourcePath, int resourceFlag) {
        ResourceTreeRoot resourceTreeRoot = ResourceTreeRoot.getSourceResourceTreeRoot(this);
        return resourceTreeRoot.exists(aSourcePath, resourceFlag);
    }

    public EList eAdapters() {
        if (this.eAdapters == null) {
            this.eAdapters = new ESynchronizedAdapterList((Notifier)this);
        }
        return this.eAdapters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eNotify(Notification notification) {
        EList eList = this.eAdapters();
        synchronized (eList) {
            super.eNotify(notification);
            switch (notification.getEventType()) {
                case 4: 
                case 6: {
                    this.defaultSourceRoot = null;
                    this.handle = null;
                }
            }
        }
    }

    public IPath getDefaultSourceRoot() {
        if (this.defaultSourceRoot == null) {
            this.defaultSourceRoot = this.getFirstTaggedRootSource();
            if (this.defaultSourceRoot == null) {
                this.defaultSourceRoot = this.getFirstRootSource();
            }
        }
        return this.defaultSourceRoot;
    }

    public void setDefaultSourceRoot(IPath defaultSourceRoot) {
        this.defaultSourceRoot = defaultSourceRoot;
    }

    public static class ESynchronizedAdapterList
    extends BasicNotifierImpl.EAdapterList {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] data() {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                return super.data();
            }
        }

        public ESynchronizedAdapterList(Notifier notifier) {
            super(notifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object object) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                return super.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object object) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                super.add(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection collection) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                return super.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                return super.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection collection) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                return super.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                super.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object object) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                return super.set(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(int newPosition, Object object) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                super.move(newPosition, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object move(int newPosition, int oldPosition) {
            ESynchronizedAdapterList eSynchronizedAdapterList = this;
            synchronized (eSynchronizedAdapterList) {
                return super.move(newPosition, oldPosition);
            }
        }
    }
}

