/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;

public class ComparingConflictResolver
implements ConflictResolver {
    private final Comparator<Activation<?>> comparator;

    public ComparingConflictResolver(Comparator<Activation<?>> comparator) {
        this.comparator = comparator;
    }

    @Override
    public ComparingConflictSet createConflictSet() {
        return new ComparingConflictSet(this.comparator);
    }

    public Comparator<Activation<?>> getComparator() {
        return this.comparator;
    }

    public class ComparingConflictSet
    implements ChangeableConflictSet {
        private SortedSet<Activation<?>> set;

        protected ComparingConflictSet(Comparator<Activation<?>> comparator) {
            Preconditions.checkArgument((comparator != null ? 1 : 0) != 0, (Object)"Comparator cannot be null!");
            this.set = Sets.newTreeSet(comparator);
        }

        @Override
        public Activation<?> getNextActivation() {
            if (!this.set.isEmpty()) {
                return this.set.first();
            }
            return null;
        }

        @Override
        public boolean addActivation(Activation<?> activation) {
            Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (Object)"Activation cannot be null!");
            return this.set.add(activation);
        }

        @Override
        public boolean removeActivation(Activation<?> activation) {
            Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (Object)"Activation cannot be null!");
            return this.set.remove(activation);
        }

        @Override
        public ComparingConflictResolver getConflictResolver() {
            return ComparingConflictResolver.this;
        }

        @Override
        public Set<Activation<?>> getNextActivations() {
            HashSet hashSet = new HashSet();
            hashSet.add(this.getNextActivation());
            return Collections.unmodifiableSet(hashSet);
        }

        @Override
        public Set<Activation<?>> getConflictingActivations() {
            return Collections.unmodifiableSet(this.set);
        }
    }
}

